package net.sourceforge.basher.internal.impl;

import org.apache.commons.logging.Log;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import bsh.Interpreter;
import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.BasherException;
import net.sourceforge.basher.TaskManager;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class BeanShellServer implements RegistryShutdownListener
{
    private Scheduler _scheduler;
    private Log _log;
    private TaskManager _taskManager;

    private int _port;
    private Interpreter _interpreter;

    public void setTaskManager( final TaskManager taskManager )
    {
        _taskManager = taskManager;
    }

    public void setScheduler(final Scheduler scheduler)
    {
        _scheduler = scheduler;
    }

    public void setPort(final int port)
    {
        _port = port;
    }

    public void setLog(final Log log)
    {
        _log = log;
    }

    public void initializeService() throws Exception
    {
       _log.info("Basher BeanShell Server starting");

        try
        {
            _interpreter = new Interpreter();

            // Export the scheduler
            _interpreter.set("scheduler", _scheduler);
            _interpreter.set("taskManager", _taskManager);

            // Export the scheduler helper
            _interpreter.eval("static import net.sourceforge.basher.internal.impl.BeanShellHelper.*");
            
            _interpreter.set("portnum", _port);
            _interpreter.eval("setAccessibility(true)"); // turn off access restrictions
            _interpreter.eval("server(portnum)");
        }
        catch (Throwable throwable)
        {
            final String errorMessage = "Unable to start the Basher Beanshell Server on port " + _port;

            _log.error(errorMessage);
            _log.error("Eror: " + throwable.getMessage());

            throw new BasherException(errorMessage, throwable);
        }

        _log.info("Basher BeanShell Server started on port " + _port);


    }

    public void registryDidShutdown()
    {
        //
    }
}
