/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal;

/**
 * Defines time based operations.  Allows operations for determining run-time since intialization.
 *
 * @author Johan Lindquist
 * @version 1.0
 */
public interface TimeSource
{
    /**
     * Returns the elapsed time of the running system.
     *
     * @return The elapsed time since startup.
     */
    public long getElapsedTime();

    /**
     * Returns the time the system was started.
     *
     * @return The start time.
     */
    public long getStartTime();

    /**
     * Returns the current time in the system.
     *
     * @return The current time.
     */
    public long getCurrentTime();

    /**
     * Resets the internal time.
     */
    public void reset();
}
