/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.basher.impl;

import net.sourceforge.basher.Average;
import net.sourceforge.basher.Collector;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.BasherContext;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class StdOutCollector extends AbstractCollector implements Collector
{
    protected void initializeCollector(final BasherContext basherContext) throws Exception
    {
        System.out.println("Initializing StdOut Collector with Basher Context: " + basherContext.getName());
    }

    public void success(final Task task, final long elapsedTime)
    {
        super.success(task, elapsedTime);
        if (isCollecting())
        {
            System.out.format("task: %s finished in %d millisecond(s)",task.getName(),elapsedTime);
        }
    }

    public void notRun(final Task task, final long elapsedTime)
    {
        super.notRun(task, elapsedTime);
    }

    public void fail(final Task task, final long elapsedTime, final Throwable throwable)
    {
        super.fail(task, elapsedTime, throwable);
        if (isCollecting())
        {
            System.out.format("task: %s failed due to %s",task.getName(),throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public Average markAverage()
    {
        final Average average = super.markAverage();
        if (isCollecting())
        {
            System.out.println(average);
        }
        return average;
    }

}
