package net.sourceforge.basher.impl;

import java.util.TimerTask;

import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.EventManager;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class EventEmitterTimerTask extends TimerTask
{
    private final EventManager _eventManager;
    private final BasherEvent _basherEvent;

    public EventEmitterTimerTask(final EventManager eventManager, final BasherEvent basherEvent)
    {
        _eventManager = eventManager;
        _basherEvent = basherEvent;
    }

    public void run()
    {
        _eventManager.publish(_basherEvent);
    }


    public String toString()
    {
        return "EventEmitterTimerTask{" +
                "_eventManager=" + _eventManager +
                ", _basherEvent=" + _basherEvent +
                '}';
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final EventEmitterTimerTask that = (EventEmitterTimerTask) o;

        if (_basherEvent != null ? !_basherEvent.equals(that._basherEvent) : that._basherEvent != null)
        {
            return false;
        }
        if (_eventManager != null ? !_eventManager.equals(that._eventManager) : that._eventManager != null)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (_eventManager != null ? _eventManager.hashCode() : 0);
        result = 31 * result + (_basherEvent != null ? _basherEvent.hashCode() : 0);
        return result;
    }
}