package net.sourceforge.basher.events;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class ThreadRemovedEvent extends BasherEvent
{
    private String _name;

    public ThreadRemovedEvent(final String name)
    {
        _name = name;
    }

    /** Returns the name of the thread to stop
     *
     * @return The name of the thread which should be stopped.
     */
    public String getName()
    {
        return _name;
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final ThreadRemovedEvent event = (ThreadRemovedEvent) o;

        if (_name != null ? !_name.equals(event._name) : event._name != null)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        return (_name != null ? _name.hashCode() : 0);
    }


    public String toString()
    {
        return "ThreadRemovedEvent{" +
                "_name='" + _name + '\'' +
                '}';
    }
}
