package net.sourceforge.basher.events;

import net.sourceforge.basher.Average;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class AverageCollectedEvent extends BasherEvent
{
    private final Average _average;

    public AverageCollectedEvent( final Average average )
    {
        _average = average;
    }

    public Average getAverage()
    {
        return _average;
    }

    @Override
    public boolean equals( final Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || getClass() != o.getClass() )
        {
            return false;
        }

        final AverageCollectedEvent that = ( AverageCollectedEvent ) o;

        if ( _average != null ? !_average.equals( that._average ) : that._average != null )
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        return _average != null ? _average.hashCode() : 0;
    }

    @Override
    public String toString()
    {
        return "AverageCollectedEvent{" +
                "_average=" + _average +
                '}';
    }
}