package net.sourceforge.basher;

import java.util.Map;
import java.util.HashMap;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TaskContext
{
    private static ThreadLocal<TaskContext> _taskContextThreadLocal = new ThreadLocal<TaskContext>()
    {
        @Override
        protected TaskContext initialValue()
        {
            return new TaskContext();
        }
    };

    private Map<Object,Object> _attributeMap = new HashMap<Object, Object>();

    public static final TaskContext getTaskContext()
    {
        return _taskContextThreadLocal.get();
    }

    public static final void reset()
    {
        _taskContextThreadLocal.get().reset();
    }

    public void setAttribute(final Object key, final Object value)
    {
        _attributeMap.put(key,value);
    }

    public Object getAttribute(final Object key)
    {
        return _attributeMap.get(key);
    }
}
