/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

/**
 * Defines operations for interacting with the scheduler service.  Users of the scheduler can stop and start
 * the scheduler, add and remove threads and retrieve statistics about currently running threads.
 *
 * @author Johan Lindquist
 * @version 1.0
 */
public interface Scheduler
{
    /**
     * Adds a thread to the currently running scheduler.
     */
    public void addThread();

    /**
     * Adds the specified number of threads to the currently running scheduler.
     *
     * @param numToAdd The number of threads to add
     */
    public void addThreads(int numToAdd);

    /**
     * Removes a thread from the currently running scheduler
     */
    public void removeThread();

    /**
     * Removes all threads from the currently running scheduler
     */
    public void removeAllThreads();

    /**
     * Stops the scheduler.
     */
    public void stop();

    /**
     * Starts the scheduler.
     */
    public void start();

    public void start(final String contextName);
    public void start(final BasherContext basherContext);
    
    /**
     * Retrieves the number of threads currently active in the scheduler.
     *
     * @return The number of currently active threads
     */
    public int getNumberOfActiveThreads();

    /**
     * Checks whether or not the scheduler is running.
     *
     * @return True if the scheduler is running, otherwise false.
     */
    public boolean isRunning();

}
