/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junitx.framework.util.SerializableTester;

public final class SerializableTesterFactory {
    private SerializableTesterFactory() {
    }

    public static SerializableTester createSerializableTester() {
        return new SerializableTesterImpl();
    }

    private static final class SerializableTesterImpl
    implements SerializableTester {
        private SerializableTesterImpl() {
        }

        public boolean serializes(Serializable serializable) {
            try {
                Object o = this.serializeDeserialize(serializable);
                return o != null;
            }
            catch (IOException ioe) {
                return false;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }

        public boolean serializesSame(Serializable serializable) {
            try {
                Object o = this.serializeDeserialize(serializable);
                return o == serializable;
            }
            catch (IOException ioe) {
                return false;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }

        public boolean serializesEqual(Serializable serializable) {
            try {
                Object o = this.serializeDeserialize(serializable);
                return o.equals(serializable);
            }
            catch (IOException ioe) {
                return false;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object serializeDeserialize(Serializable serializable) throws IOException, ClassNotFoundException {
            Object object;
            ObjectInputStream in;
            block11: {
                ObjectOutputStream out = null;
                in = null;
                try {
                    Object o;
                    ByteArrayOutputStream baout = new ByteArrayOutputStream();
                    out = new ObjectOutputStream(baout);
                    out.writeObject(serializable);
                    ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
                    in = new ObjectInputStream(bain);
                    object = o = in.readObject();
                    Object var9_8 = null;
                    if (out == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe) {
                            return null;
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            return null;
                        }
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            return object;
        }
    }
}

