/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework.util;

import junitx.framework.ObjectFactory;
import junitx.framework.util.ObjectFactoryContractTester;

public final class ObjectFactoryContractTesterFactory {
    private ObjectFactoryContractTesterFactory() {
    }

    public static ObjectFactoryContractTester createObjectFactoryContractTester(ObjectFactory factory) {
        return new ObjectFactoryContractTesterImpl(factory);
    }

    private static final class ObjectFactoryContractTesterImpl
    implements ObjectFactoryContractTester {
        private ObjectFactory factory;

        private ObjectFactoryContractTesterImpl(ObjectFactory factory) {
            this.factory = factory;
        }

        public boolean isXConsistentlyNewInstance() {
            Object x1 = this.factory.createInstanceX();
            for (int i = 0; i < 20; ++i) {
                Object x2 = this.factory.createInstanceX();
                if (x1 == x2) {
                    return false;
                }
                x1 = x2;
            }
            return true;
        }

        public boolean isYConsistentlyNewInstance() {
            Object y1 = this.factory.createInstanceX();
            for (int i = 0; i < 20; ++i) {
                Object y2 = this.factory.createInstanceX();
                if (y1 == y2) {
                    return false;
                }
                y1 = y2;
            }
            return true;
        }

        public boolean isXConsistentlySameType() {
            Class<?> c1 = this.factory.createInstanceX().getClass();
            for (int i = 0; i < 20; ++i) {
                Class<?> c2 = this.factory.createInstanceX().getClass();
                if (c1 != c2) {
                    return false;
                }
                c1 = c2;
            }
            return true;
        }

        public boolean isYConsistentlySameType() {
            Class<?> c1 = this.factory.createInstanceY().getClass();
            for (int i = 0; i < 20; ++i) {
                Class<?> c2 = this.factory.createInstanceY().getClass();
                if (c1 != c2) {
                    return false;
                }
                c1 = c2;
            }
            return true;
        }

        public boolean isXYConsistentlySameType() {
            Class<?> c1 = this.factory.createInstanceX().getClass();
            for (int i = 0; i < 20; ++i) {
                Class<?> c2 = this.factory.createInstanceY().getClass();
                if (c1 != c2) {
                    return false;
                }
                c1 = c2;
            }
            return true;
        }

        public boolean isXConsistentlyEqual() {
            Object x1 = this.factory.createInstanceX();
            for (int i = 0; i < 20; ++i) {
                Object x2 = this.factory.createInstanceX();
                if (!x1.equals(x2)) {
                    return false;
                }
                x1 = x2;
            }
            return true;
        }

        public boolean isYConsistentlyEqual() {
            Object y1 = this.factory.createInstanceY();
            for (int i = 0; i < 20; ++i) {
                Object y2 = this.factory.createInstanceY();
                if (!y1.equals(y2)) {
                    return false;
                }
                y1 = y2;
            }
            return true;
        }

        public boolean isXYConsistentlyUnequal() {
            for (int i = 0; i < 20; ++i) {
                Object y;
                Object x = this.factory.createInstanceX();
                if (!x.equals(y = this.factory.createInstanceY())) continue;
                return false;
            }
            return true;
        }

        public boolean fillsContract() {
            return this.isXConsistentlyNewInstance() && this.isXConsistentlyNewInstance() && this.isXConsistentlySameType() && this.isYConsistentlySameType() && this.isXYConsistentlySameType() && this.isXConsistentlyEqual() && this.isYConsistentlyEqual() && this.isXYConsistentlyUnequal();
        }
    }
}

