/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework.test;

import java.io.Serializable;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitx.framework.Assert;

public class TestSerializableAssert
extends TestCase {
    public TestSerializableAssert() {
    }

    public TestSerializableAssert(String name) {
        super(name);
    }

    public final void testSerializes() {
        Assert.assertSerializes((Serializable)((Object)"test"));
        Assert.assertSerializes("message", (Serializable)((Object)"test"));
        Assert.assertSerializes(new Integer(42));
        Assert.assertSerializes("message", new Integer(42));
        try {
            Assert.assertSerializes("message", null);
            TestSerializableAssert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertSerializes("message", new NotSerializes());
            TestSerializableAssert.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testNotSerializes() {
        final class Test1
        implements Serializable {
        }
        Assert.assertNotSerializes(new Test1());
        Assert.assertNotSerializes("message", new Test1());
        Assert.assertNotSerializes(new Test2());
        Assert.assertNotSerializes("message", new Test2());
        try {
            Assert.assertNotSerializes("message", null);
            TestSerializableAssert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertNotSerializes("message", new Serializes());
            TestSerializableAssert.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testSerializesSame() {
        Assert.assertSerializesSame(TypesafeEnum.A);
        Assert.assertSerializesSame("message", TypesafeEnum.A);
        Assert.assertSerializesSame(TypesafeEnum.B);
        Assert.assertSerializesSame("message", TypesafeEnum.B);
        try {
            Assert.assertSerializesSame("message", null);
            TestSerializableAssert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertSerializesSame("message", new SerializesUnsame());
            TestSerializableAssert.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testNotSerializesSame() {
        Assert.assertNotSerializesSame((Serializable)((Object)"test"));
        Assert.assertNotSerializesSame("message", (Serializable)((Object)"test"));
        Assert.assertNotSerializesSame(new Integer(42));
        Assert.assertNotSerializesSame("message", new Integer(42));
        try {
            Assert.assertNotSerializesSame("message", null);
            TestSerializableAssert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertNotSerializesSame("message", TypesafeEnum.A);
            TestSerializableAssert.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testSerializesEqual() {
        Assert.assertSerializesEquals((Serializable)((Object)"test"));
        Assert.assertSerializesEquals("message", (Serializable)((Object)"test"));
        Assert.assertSerializesEquals(new Integer(42));
        Assert.assertSerializesEquals("message", new Integer(42));
        try {
            Assert.assertSerializesEquals("message", null);
            TestSerializableAssert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertSerializesEquals("message", new SerializesUnequal());
            TestSerializableAssert.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testNotSerializesEqual() {
        Assert.assertNotSerializesEquals(new NotEqual());
        Assert.assertNotSerializesEquals("message", new NotEqual());
        try {
            Assert.assertNotSerializesEquals("message", null);
            TestSerializableAssert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertNotSerializesEquals("message", new SerializesEqual());
            TestSerializableAssert.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    private static final class SerializesUnequal
    implements Serializable {
        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return -1;
        }
    }

    private static final class SerializesEqual
    implements Serializable {
        public boolean equals(Object o) {
            return true;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static final class SerializesUnsame
    implements Serializable {
    }

    private static final class NotSerializes
    implements Serializable {
        private final Object o = new Object();

        Object m() {
            return this.o;
        }
    }

    private static final class Serializes
    implements Serializable {
    }

    private static class NotEqual
    implements Serializable {
    }

    private static final class TypesafeEnum
    implements Serializable {
        public static final TypesafeEnum A = new TypesafeEnum();
        public static final TypesafeEnum B = new TypesafeEnum();
        private static int nextOrdinal;
        private final int ordinal = nextOrdinal++;
        private static final TypesafeEnum[] VALUES;

        private TypesafeEnum() {
        }

        Object readResolve() {
            return VALUES[this.ordinal];
        }

        static {
            VALUES = new TypesafeEnum[]{A, B};
        }
    }

    private final class Test2
    implements Serializable {
        private Test2() {
        }
    }
}

