/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitx.framework.Assert;

public class TestNotEquals
extends TestCase {
    public TestNotEquals() {
    }

    public TestNotEquals(String name) {
        super(name);
    }

    public final void testBoolean() {
        Assert.assertNotEquals(true, false);
        Assert.assertNotEquals(false, true);
        Assert.assertNotEquals("message", true, false);
        Assert.assertNotEquals("message", false, true);
    }

    public final void testByte() {
        Assert.assertNotEquals((byte)7, (byte)8);
        Assert.assertNotEquals((byte)7, (byte)8);
        Assert.assertNotEquals("message", (byte)7, (byte)8);
        Assert.assertNotEquals("message", (byte)7, (byte)8);
    }

    public final void testChar() {
        Assert.assertNotEquals('a', 'b');
        Assert.assertNotEquals('b', 'a');
        Assert.assertNotEquals("message", 'a', 'b');
        Assert.assertNotEquals("message", 'b', 'a');
    }

    public final void testDouble() {
        Assert.assertNotEquals(5.0, 6.0);
        Assert.assertNotEquals(6.0, 5.0);
        Assert.assertNotEquals("message", 5.0, 6.0);
        Assert.assertNotEquals("message", 6.0, 5.0);
    }

    public final void testFloat() {
        Assert.assertNotEquals(5.0f, 6.0f);
        Assert.assertNotEquals(6.0f, 5.0f);
        Assert.assertNotEquals("message", 5.0f, 6.0f);
        Assert.assertNotEquals("message", 6.0f, 5.0f);
    }

    public final void testInt() {
        Assert.assertNotEquals(5, 6);
        Assert.assertNotEquals(6, 5);
        Assert.assertNotEquals("message", 5, 6);
        Assert.assertNotEquals("message", 6, 5);
    }

    public final void testLong() {
        Assert.assertNotEquals(5L, 6L);
        Assert.assertNotEquals(6L, 5L);
        Assert.assertNotEquals("message", 5L, 6L);
        Assert.assertNotEquals("message", 6L, 5L);
    }

    public final void testObject() {
        Dummy d1 = new Dummy("d", new Integer(7));
        Dummy d2 = new Dummy("d", new Integer(8));
        Dummy d3 = new Dummy("e", new Integer(9));
        Dummy d4 = new Dummy("f", new Integer(9));
        Assert.assertNotEquals(d1, d2);
        Assert.assertNotEquals(d1, d3);
        Assert.assertNotEquals(d1, d4);
        Assert.assertNotEquals(d2, d1);
        Assert.assertNotEquals(d2, d3);
        Assert.assertNotEquals(d2, d4);
        Assert.assertNotEquals(d3, d1);
        Assert.assertNotEquals(d3, d2);
        Assert.assertNotEquals(d3, d4);
        Assert.assertNotEquals("message", d1, d2);
        Assert.assertNotEquals("message", d1, d3);
        Assert.assertNotEquals("message", d1, d4);
        Assert.assertNotEquals("message", d2, d1);
        Assert.assertNotEquals("message", d2, d3);
        Assert.assertNotEquals("message", d2, d4);
        Assert.assertNotEquals("message", d3, d1);
        Assert.assertNotEquals("message", d3, d2);
        Assert.assertNotEquals("message", d3, d4);
        try {
            Assert.assertNotEquals("message", (Object)null, (Object)null);
            TestNotEquals.fail();
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
    }

    public final void testShort() {
        Assert.assertNotEquals((short)7, (short)8);
        Assert.assertNotEquals((short)7, (short)8);
        Assert.assertNotEquals("message", (short)7, (short)8);
        Assert.assertNotEquals("message", (short)7, (short)8);
    }

    public final void testString() {
        Assert.assertNotEquals("test1", "test2");
        Assert.assertNotEquals("test2", "test1");
        Assert.assertNotEquals(null, "test2");
        Assert.assertNotEquals("test1", null);
        Assert.assertNotEquals("message", "test1", "test2");
        Assert.assertNotEquals("message", "test2", "test1");
        Assert.assertNotEquals("message", null, "test2");
        Assert.assertNotEquals("message", "test1", null);
        try {
            Assert.assertNotEquals("message", null, null);
            TestNotEquals.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    private final class Dummy {
        private String x;
        private Integer y;

        public Dummy(String x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Dummy d = (Dummy)o;
            return this.x.equals(d.x) && this.y.equals(d.y);
        }

        public int hashCode() {
            int oddPrime = 461;
            int result = 73;
            result = result * 461 + this.x.hashCode();
            result = result * 461 + this.y.hashCode();
            return result;
        }
    }
}

