/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junitx.framework.ObjectFactory;
import junitx.framework.util.CloneableConventionTester;
import junitx.framework.util.CloneableConventionTesterFactory;
import junitx.framework.util.EqualsContractTester;
import junitx.framework.util.EqualsContractTesterFactory;
import junitx.framework.util.HashCodeContractTester;
import junitx.framework.util.HashCodeContractTesterFactory;
import junitx.framework.util.ObjectFactoryContractTester;
import junitx.framework.util.ObjectFactoryContractTesterFactory;
import junitx.framework.util.SerializableTester;
import junitx.framework.util.SerializableTesterFactory;
import junitx.framework.util.i18n.ExceptionMessages;
import junitx.framework.util.i18n.FailureMessages;

public class Assert
extends junit.framework.Assert {
    static /* synthetic */ Class class$java$lang$Object;

    protected Assert() {
    }

    public static void assertNotEquals(boolean unexpected, boolean actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(byte unexpected, byte actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(char unexpected, char actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(double unexpected, double actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(float unexpected, float actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(int unexpected, int actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(long unexpected, long actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(short unexpected, short actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(String unexpected, String actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(String message, boolean unexpected, boolean actual) {
        Assert.assertNotEquals(message, unexpected ? Boolean.TRUE : Boolean.FALSE, actual ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void assertNotEquals(String message, byte unexpected, byte actual) {
        Assert.assertNotEquals(message, new Byte(unexpected), new Byte(actual));
    }

    public static void assertNotEquals(String message, char unexpected, char actual) {
        Assert.assertNotEquals(message, new Character(unexpected), new Character(actual));
    }

    public static void assertNotEquals(String message, double unexpected, double actual) {
        Assert.assertNotEquals(message, new Double(unexpected), new Double(actual));
    }

    public static void assertNotEquals(String message, float unexpected, float actual) {
        Assert.assertNotEquals(message, new Float(unexpected), new Float(actual));
    }

    public static void assertNotEquals(String message, int unexpected, int actual) {
        Assert.assertNotEquals(message, new Integer(unexpected), new Integer(actual));
    }

    public static void assertNotEquals(String message, long unexpected, long actual) {
        Assert.assertNotEquals(message, new Long(unexpected), new Long(actual));
    }

    public static void assertNotEquals(String message, Object unexpected, Object actual) {
        if (unexpected == null && actual == null || unexpected != null && unexpected.equals(actual)) {
            StringBuffer formatted = new StringBuffer();
            if (message != null) {
                formatted.append(message);
                formatted.append(' ');
            }
            formatted.append(FailureMessages.unexpectedNotEqual(unexpected));
            throw new AssertionFailedError(formatted.toString());
        }
    }

    public static void assertNotEquals(String message, short unexpected, short actual) {
        Assert.assertNotEquals(message, new Short(unexpected), new Short(actual));
    }

    public static void assertNotEquals(String message, String unexpected, String actual) {
        if (unexpected == null && actual == null || unexpected != null && unexpected.equals(actual)) {
            StringBuffer formatted = new StringBuffer();
            if (message != null) {
                formatted.append(message);
                formatted.append(' ');
            }
            formatted.append(FailureMessages.unexpectedNotEqual(unexpected));
            throw new AssertionFailedError(formatted.toString());
        }
    }

    public static void assertArrayElementsSame(Object[] array1, Object[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsSame(null, array1, array2);
    }

    public static void assertArrayElementsSame(String message, Object[] array1, Object[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertSame((Object)array1[i], (Object)array2[i]);
        }
    }

    public static void assertArrayElementsNotSame(Object[] array1, Object[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotSame(null, array1, array2);
    }

    public static void assertArrayElementsNotSame(String message, Object[] array1, Object[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotSame((Object)array1[i], (Object)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(Object[] array1, Object[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, Object[] array1, Object[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((Object)array1[i], (Object)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(boolean[] array1, boolean[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, boolean[] array1, boolean[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((boolean)array1[i], (boolean)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(byte[] array1, byte[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, byte[] array1, byte[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((byte)array1[i], (byte)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(short[] array1, short[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, short[] array1, short[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((short)array1[i], (short)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(char[] array1, char[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, char[] array1, char[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((char)array1[i], (char)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(int[] array1, int[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, int[] array1, int[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((int)array1[i], (int)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(float[] array1, float[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, float[] array1, float[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((float)array1[i], (float)array2[i], (float)0.0f);
        }
    }

    public static void assertArrayElementsEquals(long[] array1, long[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, long[] array1, long[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)array2[i]);
        }
    }

    public static void assertArrayElementsEquals(double[] array1, double[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsEquals(null, array1, array2);
    }

    public static void assertArrayElementsEquals(String message, double[] array1, double[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((double)array1[i], (double)array2[i], (double)0.0);
        }
    }

    public static void assertArrayElementsNotEquals(Object[] array1, Object[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, Object[] array1, Object[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(boolean[] array1, boolean[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, boolean[] array1, boolean[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(byte[] array1, byte[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, byte[] array1, byte[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(short[] array1, short[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, short[] array1, short[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(char[] array1, char[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, char[] array1, char[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(int[] array1, int[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, int[] array1, int[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(float[] array1, float[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, float[] array1, float[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(long[] array1, long[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, long[] array1, long[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsNotEquals(double[] array1, double[] array2) throws IllegalArgumentException {
        Assert.assertArrayElementsNotEquals(null, array1, array2);
    }

    public static void assertArrayElementsNotEquals(String message, double[] array1, double[] array2) throws IllegalArgumentException {
        if (array1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array1"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array2"));
        }
        if (array1.length != array2.length) {
            throw new AssertionFailedError(message);
        }
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertNotEquals(array1[i], array2[i]);
        }
    }

    public static void assertArrayElementsClassEquals(Object[] array, Class c) throws IllegalArgumentException {
        Assert.assertArrayElementsClassEquals(null, array, c);
    }

    public static void assertArrayElementsClassEquals(String message, Object[] array, Class c) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i].getClass() == c) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertArrayElementsClassNotEquals(Object[] array, Class c) throws IllegalArgumentException {
        Assert.assertArrayElementsClassNotEquals(null, array, c);
    }

    public static void assertArrayElementsClassNotEquals(String message, Object[] array, Class c) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i].getClass() != c) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertArrayElementsAssignableFrom(Object[] array, Class c) throws IllegalArgumentException {
        Assert.assertArrayElementsAssignableFrom(null, array, c);
    }

    public static void assertArrayElementsAssignableFrom(String message, Object[] array, Class c) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        for (int i = 0; i < array.length; ++i) {
            Assert.assertAssignableFrom(message, c, array[i].getClass());
        }
    }

    public static void assertArrayElementsNotAssignableFrom(Object[] array, Class c) throws IllegalArgumentException {
        Assert.assertArrayElementsNotAssignableFrom(null, array, c);
    }

    public static void assertArrayElementsNotAssignableFrom(String message, Object[] array, Class c) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("array"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        for (int i = 0; i < array.length; ++i) {
            Assert.assertNotAssignableFrom(message, c, array[i].getClass());
        }
    }

    public static void assertAssignableFrom(Class base, Class derived) throws IllegalArgumentException {
        Assert.assertAssignableFrom(null, base, derived);
    }

    public static void assertAssignableFrom(String message, Class base, Class derived) throws IllegalArgumentException {
        if (base == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("base"));
        }
        if (derived == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("derived"));
        }
        if (!base.isAssignableFrom(derived)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotAssignableFrom(Class base, Class derived) throws IllegalArgumentException {
        Assert.assertNotAssignableFrom(null, base, derived);
    }

    public static void assertNotAssignableFrom(String message, Class base, Class derived) throws IllegalArgumentException {
        if (base == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("base"));
        }
        if (derived == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("derived"));
        }
        if (base.isAssignableFrom(derived)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertIsInstance(Class c, Object o) throws IllegalArgumentException {
        Assert.assertIsInstance(null, c, o);
    }

    public static void assertIsInstance(String message, Class c, Object o) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (o == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("o"));
        }
        if (!c.isInstance(o)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotIsInstance(Class c, Object o) throws IllegalArgumentException {
        Assert.assertNotIsInstance(null, c, o);
    }

    public static void assertNotIsInstance(String message, Class c, Object o) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (o == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("o"));
        }
        if (c.isInstance(o)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertDirectInterfaceOf(Class c, Class iface) throws IllegalArgumentException {
        Assert.assertDirectInterfaceOf(null, c, iface);
    }

    public static void assertDirectInterfaceOf(String message, Class c, Class iface) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (iface == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("iface"));
        }
        Class<?>[] ifaces = c.getInterfaces();
        boolean found = false;
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i] != iface) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotDirectInterfaceOf(Class c, Class iface) throws IllegalArgumentException {
        Assert.assertNotDirectInterfaceOf(null, c, iface);
    }

    public static void assertNotDirectInterfaceOf(String message, Class c, Class iface) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (iface == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("iface"));
        }
        Class<?>[] ifaces = c.getInterfaces();
        boolean found = false;
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i] != iface) continue;
            found = true;
            break;
        }
        if (found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertDirectSuperclassOf(Class c, Class s) throws IllegalArgumentException {
        Assert.assertDirectSuperclassOf(null, c, s);
    }

    public static void assertDirectSuperclassOf(String message, Class c, Class s) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (s == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("s"));
        }
        Class sclass = c.getSuperclass();
        if (sclass == null || sclass != s) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotDirectSuperclassOf(Class c, Class s) throws IllegalArgumentException {
        Assert.assertNotDirectSuperclassOf(null, c, s);
    }

    public static void assertNotDirectSuperclassOf(String message, Class c, Class s) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (s == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("s"));
        }
        Class sclass = c.getSuperclass();
        if (sclass != null && sclass == s) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertMemberClassOf(Class c, Class member) throws IllegalArgumentException {
        Assert.assertMemberClassOf(null, c, member);
    }

    public static void assertMemberClassOf(String message, Class c, Class member) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (member == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("member"));
        }
        Class<?>[] members = c.getClasses();
        boolean found = false;
        for (int i = 0; i < members.length; ++i) {
            if (members[i] != member) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotMemberClassOf(Class c, Class member) throws IllegalArgumentException {
        Assert.assertNotMemberClassOf(null, c, member);
    }

    public static void assertNotMemberClassOf(String message, Class c, Class member) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (member == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("member"));
        }
        Class<?>[] members = c.getClasses();
        boolean found = false;
        for (int i = 0; i < members.length; ++i) {
            if (members[i] != member) continue;
            found = true;
            break;
        }
        if (found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertDeclaredMemberClassOf(Class c, Class member) throws IllegalArgumentException {
        Assert.assertDeclaredMemberClassOf(null, c, member);
    }

    public static void assertDeclaredMemberClassOf(String message, Class c, Class member) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (member == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("member"));
        }
        Class<?>[] members = c.getDeclaredClasses();
        boolean found = false;
        for (int i = 0; i < members.length; ++i) {
            if (members[i] != member) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotDeclaredMemberClassOf(Class c, Class member) throws IllegalArgumentException {
        Assert.assertNotDeclaredMemberClassOf(null, c, member);
    }

    public static void assertNotDeclaredMemberClassOf(String message, Class c, Class member) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (member == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("member"));
        }
        Class<?>[] members = c.getDeclaredClasses();
        boolean found = false;
        for (int i = 0; i < members.length; ++i) {
            if (members[i] != member) continue;
            found = true;
            break;
        }
        if (found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertDynamicallyInstantiable(Class c) throws IllegalArgumentException {
        Assert.assertDynamicallyInstantiable(null, c);
    }

    public static void assertDynamicallyInstantiable(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException ie) {
            throw new AssertionFailedError(message);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotDynamicallyInstantiable(Class c) throws IllegalArgumentException {
        Assert.assertNotDynamicallyInstantiable(null, c);
    }

    public static void assertNotDynamicallyInstantiable(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        try {
            c.newInstance();
            throw new AssertionFailedError(message);
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void assertClassLoads(String name) throws IllegalArgumentException {
        Assert.assertClassLoads(null, name);
    }

    public static void assertClassLoads(String message, String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("name"));
        }
        try {
            Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotClassLoads(String name) throws IllegalArgumentException {
        Assert.assertNotClassLoads(null, name);
    }

    public static void assertNotClassLoads(String message, String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("name"));
        }
        try {
            Class.forName(name);
            throw new AssertionFailedError(message);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    public static Constructor assertClassHasConstructor(Class c, Class[] parameterTypes) throws IllegalArgumentException {
        return Assert.assertClassHasConstructor(null, c, parameterTypes);
    }

    public static Constructor assertClassHasConstructor(String message, Class c, Class[] parameterTypes) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        try {
            return c.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotClassHasConstructor(Class c, Class[] parameterTypes) throws IllegalArgumentException {
        Assert.assertNotClassHasConstructor(null, c, parameterTypes);
    }

    public static void assertNotClassHasConstructor(String message, Class c, Class[] parameterTypes) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        try {
            c.getDeclaredConstructor(parameterTypes);
            throw new AssertionFailedError(message);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
    }

    public static Field assertClassHasField(Class c, String name) throws IllegalArgumentException {
        return Assert.assertClassHasField(null, c, name);
    }

    public static Field assertClassHasField(String message, Class c, String name) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (name == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("name"));
        }
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotClassHasField(Class c, String name) throws IllegalArgumentException {
        Assert.assertNotClassHasField(null, c, name);
    }

    public static void assertNotClassHasField(String message, Class c, String name) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (name == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("name"));
        }
        try {
            c.getDeclaredField(name);
            throw new AssertionFailedError(message);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    public static Method assertClassHasMethod(Class c, String name, Class[] parameterTypes) throws IllegalArgumentException {
        return Assert.assertClassHasMethod(null, c, name, parameterTypes);
    }

    public static Method assertClassHasMethod(String message, Class c, String name, Class[] parameterTypes) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (name == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("name"));
        }
        try {
            return c.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotClassHasMethod(Class c, String name, Class[] parameterTypes) throws IllegalArgumentException {
        Assert.assertNotClassHasMethod(null, c, name, parameterTypes);
    }

    public static void assertNotClassHasMethod(String message, Class c, String name, Class[] parameterTypes) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        if (name == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("name"));
        }
        try {
            c.getDeclaredMethod(name, parameterTypes);
            throw new AssertionFailedError(message);
        }
        catch (NoSuchMethodException nsme) {
            return;
        }
    }

    public static void assertEqualsContract(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsContract(null, factory);
    }

    public static void assertEqualsContract(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.fillsContract()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsUnequalToNewObject(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsUnequalToNewObject(null, factory);
    }

    public static void assertEqualsUnequalToNewObject(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isUnequalToNewObject()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsUnequalToNull(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsUnequalToNull(null, factory);
    }

    public static void assertEqualsUnequalToNull(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isUnequalToNull()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsConsistentAcrossInvocations(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsConsistentAcrossInvocations(null, factory);
    }

    public static void assertEqualsConsistentAcrossInvocations(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isConsistentAcrossInvocations()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsReflexive(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsReflexive(null, factory);
    }

    public static void assertEqualsReflexive(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isReflexive()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsSymmetric(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsSymmetric(null, factory);
    }

    public static void assertEqualsSymmetric(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isSymmetric()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsTransitive(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsTransitive(null, factory);
    }

    public static void assertEqualsTransitive(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isTransitive()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertUnequalToUnequalInstance(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertUnequalToUnequalInstance(null, factory);
    }

    public static void assertUnequalToUnequalInstance(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.isUnequalToUnequalInstance()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHashCodeContract(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertHashCodeContract(null, factory);
    }

    public static void assertHashCodeContract(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        HashCodeContractTester tester = HashCodeContractTesterFactory.createHashCodeContractTester(factory);
        if (!tester.fillsContract()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHashCodeConsistent(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertHashCodeConsistent(null, factory);
    }

    public static void assertHashCodeConsistent(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        HashCodeContractTester tester = HashCodeContractTesterFactory.createHashCodeContractTester(factory);
        if (!tester.isConsistent()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHashCodeEqualOnEqualInstance(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertHashCodeEqualOnEqualInstance(null, factory);
    }

    public static void assertHashCodeEqualOnEqualInstance(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        HashCodeContractTester tester = HashCodeContractTesterFactory.createHashCodeContractTester(factory);
        if (!tester.isEqualOnEqualInstance()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsHashCodeSymbiotic(Class c) throws IllegalArgumentException {
        Assert.assertEqualsHashCodeSymbiotic(null, c);
    }

    public static void assertEqualsHashCodeSymbiotic(String message, Class c) throws IllegalArgumentException {
        boolean hashCodeExists;
        boolean equalsExists;
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        try {
            c.getDeclaredMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = Assert.class$("java.lang.Object")) : class$java$lang$Object);
            equalsExists = true;
        }
        catch (NoSuchMethodException nsme) {
            equalsExists = false;
        }
        try {
            c.getDeclaredMethod("hashCode", null);
            hashCodeExists = true;
        }
        catch (NoSuchMethodException nsme) {
            hashCodeExists = false;
        }
        if (equalsExists != hashCodeExists) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsComparesToZero(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsComparesToZero(null, factory);
    }

    public static void assertEqualsComparesToZero(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (!tester.comparesToZero()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertEqualsNotComparesToZero(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertEqualsNotComparesToZero(null, factory);
    }

    public static void assertEqualsNotComparesToZero(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        EqualsContractTester tester = EqualsContractTesterFactory.createEqualsContractTester(factory);
        if (tester.comparesToZero()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCloneableClonedNewObject(Cloneable cloneable) throws IllegalArgumentException {
        Assert.assertCloneableClonedNewObject(null, cloneable);
    }

    public static void assertCloneableClonedNewObject(String message, Cloneable cloneable) throws IllegalArgumentException {
        if (cloneable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("cloneable"));
        }
        CloneableConventionTester tester = CloneableConventionTesterFactory.createCloneableConventionTester(cloneable);
        if (!tester.isClonedNewObject()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCloneableNotClonedNewObject(Cloneable cloneable) throws IllegalArgumentException {
        Assert.assertCloneableNotClonedNewObject(null, cloneable);
    }

    public static void assertCloneableNotClonedNewObject(String message, Cloneable cloneable) throws IllegalArgumentException {
        if (cloneable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("cloneable"));
        }
        CloneableConventionTester tester = CloneableConventionTesterFactory.createCloneableConventionTester(cloneable);
        if (tester.isClonedNewObject()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCloneableEqual(Cloneable cloneable) throws IllegalArgumentException {
        Assert.assertCloneableEqual(null, cloneable);
    }

    public static void assertCloneableEqual(String message, Cloneable cloneable) throws IllegalArgumentException {
        if (cloneable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("cloneable"));
        }
        CloneableConventionTester tester = CloneableConventionTesterFactory.createCloneableConventionTester(cloneable);
        if (!tester.isClonedEqual()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCloneableNotEqual(Cloneable cloneable) throws IllegalArgumentException {
        Assert.assertCloneableNotEqual(null, cloneable);
    }

    public static void assertCloneableNotEqual(String message, Cloneable cloneable) throws IllegalArgumentException {
        if (cloneable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("cloneable"));
        }
        CloneableConventionTester tester = CloneableConventionTesterFactory.createCloneableConventionTester(cloneable);
        if (tester.isClonedEqual()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCloneableClassEqual(Cloneable cloneable) throws IllegalArgumentException {
        Assert.assertCloneableClassEqual(null, cloneable);
    }

    public static void assertCloneableClassEqual(String message, Cloneable cloneable) throws IllegalArgumentException {
        if (cloneable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("cloneable"));
        }
        CloneableConventionTester tester = CloneableConventionTesterFactory.createCloneableConventionTester(cloneable);
        if (!tester.isClonedClassEqual()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCloneableNotClassEqual(Cloneable cloneable) throws IllegalArgumentException {
        Assert.assertCloneableNotClassEqual(null, cloneable);
    }

    public static void assertCloneableNotClassEqual(String message, Cloneable cloneable) throws IllegalArgumentException {
        if (cloneable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("cloneable"));
        }
        CloneableConventionTester tester = CloneableConventionTesterFactory.createCloneableConventionTester(cloneable);
        if (tester.isClonedClassEqual()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryContract(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryContract(null, factory);
    }

    public static void assertObjectFactoryContract(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.fillsContract()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryXConsistentlySameType(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryXConsistentlySameType(null, factory);
    }

    public static void assertObjectFactoryXConsistentlyNewInstance(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryXConsistentlyNewInstance(null, factory);
    }

    public static void assertObjectFactoryXConsistentlyNewInstance(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isYConsistentlyNewInstance()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryYConsistentlyNewInstance(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryYConsistentlyNewInstance(null, factory);
    }

    public static void assertObjectFactoryYConsistentlyNewInstance(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isYConsistentlyNewInstance()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryXConsistentlySameType(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isXConsistentlySameType()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryYConsistentlySameType(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryYConsistentlySameType(null, factory);
    }

    public static void assertObjectFactoryYConsistentlySameType(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isYConsistentlySameType()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryXYConsistentlySameType(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryXYConsistentlySameType(null, factory);
    }

    public static void assertObjectFactoryXYConsistentlySameType(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isXYConsistentlySameType()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryXConsistentlyEqual(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryXConsistentlyEqual(null, factory);
    }

    public static void assertObjectFactoryXConsistentlyEqual(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isXConsistentlyEqual()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryYConsistentlyEqual(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryYConsistentlyEqual(null, factory);
    }

    public static void assertObjectFactoryYConsistentlyEqual(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isYConsistentlyEqual()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertObjectFactoryXYConsistentlyUnequal(ObjectFactory factory) throws IllegalArgumentException {
        Assert.assertObjectFactoryXYConsistentlyUnequal(null, factory);
    }

    public static void assertObjectFactoryXYConsistentlyUnequal(String message, ObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("factory"));
        }
        ObjectFactoryContractTester tester = ObjectFactoryContractTesterFactory.createObjectFactoryContractTester(factory);
        if (!tester.isXYConsistentlyUnequal()) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsSame(Collection c1, Collection c2) throws IllegalArgumentException {
        Assert.assertCollectionElementsSame(null, c1, c2);
    }

    public static void assertCollectionElementsSame(String message, Collection c1, Collection c2) throws IllegalArgumentException {
        if (c1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c1"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c2"));
        }
        if (c1.size() != c2.size()) {
            throw new AssertionFailedError(message);
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object e2;
            Object e1 = i1.next();
            if (e1 == (e2 = i2.next())) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsNotSame(Collection c1, Collection c2) throws IllegalArgumentException {
        Assert.assertCollectionElementsNotSame(null, c1, c2);
    }

    public static void assertCollectionElementsNotSame(String message, Collection c1, Collection c2) throws IllegalArgumentException {
        if (c1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c1"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c2"));
        }
        if (c1.size() != c2.size()) {
            throw new AssertionFailedError(message);
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object e2;
            Object e1 = i1.next();
            if (e1 != (e2 = i2.next())) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsEquals(Collection c1, Collection c2) throws IllegalArgumentException {
        Assert.assertCollectionElementsEquals(null, c1, c2);
    }

    public static void assertCollectionElementsEquals(String message, Collection c1, Collection c2) throws IllegalArgumentException {
        if (c1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c1"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c2"));
        }
        if (c1.size() != c2.size()) {
            throw new AssertionFailedError(message);
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object e2;
            Object e1 = i1.next();
            if (e1.equals(e2 = i2.next())) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsNotEquals(Collection c1, Collection c2) throws IllegalArgumentException {
        Assert.assertCollectionElementsNotEquals(null, c1, c2);
    }

    public static void assertCollectionElementsNotEquals(String message, Collection c1, Collection c2) throws IllegalArgumentException {
        if (c1 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c1"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c2"));
        }
        if (c1.size() != c2.size()) {
            throw new AssertionFailedError(message);
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object e2;
            Object e1 = i1.next();
            if (!e1.equals(e2 = i2.next())) continue;
            System.out.println("[" + c1 + "]\t[" + c2 + "]\t" + e1 + " equals " + e2);
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsClassEquals(Collection co, Class c) throws IllegalArgumentException {
        Assert.assertCollectionElementsClassEquals(null, co, c);
    }

    public static void assertCollectionElementsClassEquals(String message, Collection co, Class c) throws IllegalArgumentException {
        if (co == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("co"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        Iterator i = co.iterator();
        while (i.hasNext()) {
            if (i.next().getClass() == c) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsClassNotEquals(Collection co, Class c) throws IllegalArgumentException {
        Assert.assertCollectionElementsClassNotEquals(null, co, c);
    }

    public static void assertCollectionElementsClassNotEquals(String message, Collection co, Class c) throws IllegalArgumentException {
        if (co == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("co"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        Iterator i = co.iterator();
        while (i.hasNext()) {
            if (i.next().getClass() != c) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsAssignableFrom(Collection co, Class c) throws IllegalArgumentException {
        Assert.assertCollectionElementsAssignableFrom(null, co, c);
    }

    public static void assertCollectionElementsAssignableFrom(String message, Collection co, Class c) throws IllegalArgumentException {
        if (co == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("l"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        Iterator i = co.iterator();
        while (i.hasNext()) {
            if (c.isAssignableFrom(i.next().getClass())) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCollectionElementsNotAssignableFrom(Collection co, Class c) throws IllegalArgumentException {
        Assert.assertCollectionElementsNotAssignableFrom(null, co, c);
    }

    public static void assertCollectionElementsNotAssignableFrom(String message, Collection co, Class c) throws IllegalArgumentException {
        if (co == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("l"));
        }
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        Iterator i = co.iterator();
        while (i.hasNext()) {
            if (!i.next().getClass().isAssignableFrom(c)) continue;
            throw new AssertionFailedError(message);
        }
    }

    public static void assertDeclaresException(Method m, Class e) throws IllegalArgumentException {
        Assert.assertDeclaresException(null, m, e);
    }

    public static void assertDeclaresException(String message, Method m, Class e) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        if (e == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("e"));
        }
        Class<?>[] exceptions = m.getExceptionTypes();
        boolean found = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] != e) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotDeclaresException(Method m, Class e) throws IllegalArgumentException {
        Assert.assertNotDeclaresException(null, m, e);
    }

    public static void assertNotDeclaresException(String message, Method m, Class e) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        if (e == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("e"));
        }
        Class<?>[] exceptions = m.getExceptionTypes();
        boolean found = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] != e) continue;
            found = true;
            break;
        }
        if (found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHasParameter(Method m, Class param) throws IllegalArgumentException {
        Assert.assertHasParameter(null, m, param);
    }

    public static void assertHasParameter(String message, Method m, Class param) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        if (param == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("param"));
        }
        Class<?>[] params = m.getParameterTypes();
        boolean found = false;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != param) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotHasParameter(Method m, Class param) throws IllegalArgumentException {
        Assert.assertNotHasParameter(null, m, param);
    }

    public static void assertNotHasParameter(String message, Method m, Class param) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        if (param == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("param"));
        }
        Class<?>[] params = m.getParameterTypes();
        boolean found = false;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != param) continue;
            found = true;
            break;
        }
        if (found) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCanInvoke(Method m, Object obj, Object[] args) throws IllegalArgumentException {
        Assert.assertCanInvoke(null, m, obj, args);
    }

    public static void assertCanInvoke(String message, Method m, Object obj, Object[] args) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("obj"));
        }
        try {
            m.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailedError(message);
        }
        catch (InvocationTargetException ite) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertCanNotInvoke(Method m, Object obj, Object[] args) throws IllegalArgumentException {
        Assert.assertCanNotInvoke(null, m, obj, args);
    }

    public static void assertCanNotInvoke(String message, Method m, Object obj, Object[] args) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("obj"));
        }
        try {
            m.invoke(obj, args);
            throw new AssertionFailedError(message);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
    }

    public static void assertAbstract(Class c) throws IllegalArgumentException {
        Assert.assertAbstract(null, c);
    }

    public static void assertAbstract(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isAbstract(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotAbstract(Class c) throws IllegalArgumentException {
        Assert.assertNotAbstract(null, c);
    }

    public static void assertNotAbstract(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertAbstract(Method m) throws IllegalArgumentException {
        Assert.assertAbstract(null, m);
    }

    public static void assertAbstract(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isAbstract(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotAbstract(Method m) throws IllegalArgumentException {
        Assert.assertNotAbstract(null, m);
    }

    public static void assertNotAbstract(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertFinal(Class c) throws IllegalArgumentException {
        Assert.assertFinal(null, c);
    }

    public static void assertFinal(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isFinal(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotFinal(Class c) throws IllegalArgumentException {
        Assert.assertNotFinal(null, c);
    }

    public static void assertNotFinal(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertFinal(Field f) throws IllegalArgumentException {
        Assert.assertFinal(null, f);
    }

    public static void assertFinal(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isFinal(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotFinal(Field f) throws IllegalArgumentException {
        Assert.assertNotFinal(null, f);
    }

    public static void assertNotFinal(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertFinal(Method m) throws IllegalArgumentException {
        Assert.assertFinal(null, m);
    }

    public static void assertFinal(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isFinal(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotFinal(Method m) throws IllegalArgumentException {
        Assert.assertNotFinal(null, m);
    }

    public static void assertNotFinal(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPublic(Class c) throws IllegalArgumentException {
        Assert.assertPublic(null, c);
    }

    public static void assertPublic(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPublic(Class c) throws IllegalArgumentException {
        Assert.assertNotPublic(null, c);
    }

    public static void assertNotPublic(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPublic(Constructor c) throws IllegalArgumentException {
        Assert.assertPublic(null, c);
    }

    public static void assertPublic(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPublic(Constructor c) throws IllegalArgumentException {
        Assert.assertNotPublic(null, c);
    }

    public static void assertNotPublic(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPublic(Field f) throws IllegalArgumentException {
        Assert.assertPublic(null, f);
    }

    public static void assertPublic(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPublic(Field f) throws IllegalArgumentException {
        Assert.assertNotPublic(null, f);
    }

    public static void assertNotPublic(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPublic(Method m) throws IllegalArgumentException {
        Assert.assertPublic(null, m);
    }

    public static void assertPublic(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPublic(Method m) throws IllegalArgumentException {
        Assert.assertNotPublic(null, m);
    }

    public static void assertNotPublic(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPackagePrivate(Class c) throws IllegalArgumentException {
        Assert.assertPackagePrivate(null, c);
    }

    public static void assertPackagePrivate(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPackagePrivate(Class c) throws IllegalArgumentException {
        Assert.assertNotPackagePrivate(null, c);
    }

    public static void assertNotPackagePrivate(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!(Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers))) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPackagePrivate(Constructor c) throws IllegalArgumentException {
        Assert.assertPackagePrivate(null, c);
    }

    public static void assertPackagePrivate(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPackagePrivate(Constructor c) throws IllegalArgumentException {
        Assert.assertNotPackagePrivate(null, c);
    }

    public static void assertNotPackagePrivate(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!(Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers))) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPackagePrivate(Field f) throws IllegalArgumentException {
        Assert.assertPackagePrivate(null, f);
    }

    public static void assertPackagePrivate(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPackagePrivate(Field f) throws IllegalArgumentException {
        Assert.assertNotPackagePrivate(null, f);
    }

    public static void assertNotPackagePrivate(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!(Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers))) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPackagePrivate(Method m) throws IllegalArgumentException {
        Assert.assertPackagePrivate(null, m);
    }

    public static void assertPackagePrivate(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPackagePrivate(Method m) throws IllegalArgumentException {
        Assert.assertNotPackagePrivate(null, m);
    }

    public static void assertNotPackagePrivate(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!(Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers))) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertProtected(Class c) throws IllegalArgumentException {
        Assert.assertProtected(null, c);
    }

    public static void assertProtected(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotProtected(Class c) throws IllegalArgumentException {
        Assert.assertNotProtected(null, c);
    }

    public static void assertNotProtected(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertProtected(Constructor c) throws IllegalArgumentException {
        Assert.assertProtected(null, c);
    }

    public static void assertProtected(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotProtected(Constructor c) throws IllegalArgumentException {
        Assert.assertNotProtected(null, c);
    }

    public static void assertNotProtected(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertProtected(Field f) throws IllegalArgumentException {
        Assert.assertProtected(null, f);
    }

    public static void assertProtected(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotProtected(Field f) throws IllegalArgumentException {
        Assert.assertNotProtected(null, f);
    }

    public static void assertNotProtected(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertProtected(Method m) throws IllegalArgumentException {
        Assert.assertProtected(null, m);
    }

    public static void assertProtected(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotProtected(Method m) throws IllegalArgumentException {
        Assert.assertNotProtected(null, m);
    }

    public static void assertNotProtected(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isProtected(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPrivate(Class c) throws IllegalArgumentException {
        Assert.assertPrivate(null, c);
    }

    public static void assertPrivate(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPrivate(Class c) throws IllegalArgumentException {
        Assert.assertNotPrivate(null, c);
    }

    public static void assertNotPrivate(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPrivate(Constructor c) throws IllegalArgumentException {
        Assert.assertPrivate(null, c);
    }

    public static void assertPrivate(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPrivate(Constructor c) throws IllegalArgumentException {
        Assert.assertNotPrivate(null, c);
    }

    public static void assertNotPrivate(String message, Constructor c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPrivate(Field f) throws IllegalArgumentException {
        Assert.assertPrivate(null, f);
    }

    public static void assertPrivate(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPrivate(Field f) throws IllegalArgumentException {
        Assert.assertNotPrivate(null, f);
    }

    public static void assertNotPrivate(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertPrivate(Method m) throws IllegalArgumentException {
        Assert.assertPrivate(null, m);
    }

    public static void assertPrivate(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotPrivate(Method m) throws IllegalArgumentException {
        Assert.assertNotPrivate(null, m);
    }

    public static void assertNotPrivate(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertStatic(Class c) throws IllegalArgumentException {
        Assert.assertStatic(null, c);
    }

    public static void assertStatic(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotStatic(Class c) throws IllegalArgumentException {
        Assert.assertNotStatic(null, c);
    }

    public static void assertNotStatic(String message, Class c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("c"));
        }
        int modifiers = c.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertStatic(Field f) throws IllegalArgumentException {
        Assert.assertStatic(null, f);
    }

    public static void assertStatic(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotStatic(Field f) throws IllegalArgumentException {
        Assert.assertNotStatic(null, f);
    }

    public static void assertNotStatic(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertStatic(Method m) throws IllegalArgumentException {
        Assert.assertStatic(null, m);
    }

    public static void assertStatic(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotStatic(Method m) throws IllegalArgumentException {
        Assert.assertNotStatic(null, m);
    }

    public static void assertNotStatic(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertStrictfp(Method m) throws IllegalArgumentException {
        Assert.assertStrictfp(null, m);
    }

    public static void assertStrictfp(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStrict(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotStrictfp(Method m) throws IllegalArgumentException {
        Assert.assertNotStrictfp(null, m);
    }

    public static void assertNotStrictfp(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isStrict(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertSynchronized(Method m) throws IllegalArgumentException {
        Assert.assertSynchronized(null, m);
    }

    public static void assertSynchronized(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isSynchronized(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotSynchronized(Method m) throws IllegalArgumentException {
        Assert.assertNotSynchronized(null, m);
    }

    public static void assertNotSynchronized(String message, Method m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("m"));
        }
        int modifiers = m.getModifiers();
        if (Modifier.isSynchronized(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertTransient(Field f) throws IllegalArgumentException {
        Assert.assertTransient(null, f);
    }

    public static void assertTransient(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isTransient(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotTransient(Field f) throws IllegalArgumentException {
        Assert.assertNotTransient(null, f);
    }

    public static void assertNotTransient(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertVolatile(Field f) throws IllegalArgumentException {
        Assert.assertVolatile(null, f);
    }

    public static void assertVolatile(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (!Modifier.isVolatile(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotVolatile(Field f) throws IllegalArgumentException {
        Assert.assertNotVolatile(null, f);
    }

    public static void assertNotVolatile(String message, Field f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("f"));
        }
        int modifiers = f.getModifiers();
        if (Modifier.isVolatile(modifiers)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertSerializes(Serializable serializable) throws IllegalArgumentException {
        Assert.assertSerializes(null, serializable);
    }

    public static void assertSerializes(String message, Serializable serializable) throws IllegalArgumentException {
        if (serializable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("serializable"));
        }
        SerializableTester tester = SerializableTesterFactory.createSerializableTester();
        if (!tester.serializes(serializable)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotSerializes(Serializable serializable) throws IllegalArgumentException {
        Assert.assertNotSerializes(null, serializable);
    }

    public static void assertNotSerializes(String message, Serializable serializable) throws IllegalArgumentException {
        if (serializable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("serializable"));
        }
        SerializableTester tester = SerializableTesterFactory.createSerializableTester();
        if (tester.serializes(serializable)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertSerializesSame(Serializable serializable) throws IllegalArgumentException {
        Assert.assertSerializesSame(null, serializable);
    }

    public static void assertSerializesSame(String message, Serializable serializable) throws IllegalArgumentException {
        if (serializable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("serializable"));
        }
        SerializableTester tester = SerializableTesterFactory.createSerializableTester();
        if (!tester.serializesSame(serializable)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotSerializesSame(Serializable serializable) throws IllegalArgumentException {
        Assert.assertNotSerializesSame(null, serializable);
    }

    public static void assertNotSerializesSame(String message, Serializable serializable) throws IllegalArgumentException {
        if (serializable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("serializable"));
        }
        SerializableTester tester = SerializableTesterFactory.createSerializableTester();
        if (tester.serializesSame(serializable)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertSerializesEquals(Serializable serializable) throws IllegalArgumentException {
        Assert.assertSerializesEquals(null, serializable);
    }

    public static void assertSerializesEquals(String message, Serializable serializable) throws IllegalArgumentException {
        if (serializable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("serializable"));
        }
        SerializableTester tester = SerializableTesterFactory.createSerializableTester();
        if (!tester.serializesEqual(serializable)) {
            throw new AssertionFailedError(message);
        }
    }

    public static void assertNotSerializesEquals(Serializable serializable) throws IllegalArgumentException {
        Assert.assertNotSerializesEquals(null, serializable);
    }

    public static void assertNotSerializesEquals(String message, Serializable serializable) throws IllegalArgumentException {
        if (serializable == null) {
            throw new IllegalArgumentException(ExceptionMessages.parameterNull("serializable"));
        }
        SerializableTester tester = SerializableTesterFactory.createSerializableTester();
        if (tester.serializesEqual(serializable)) {
            throw new AssertionFailedError(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

