/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.tasks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.TaskFailedException;
import net.sourceforge.basher.TaskNotRunException;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements Task {
    protected Log _log;
    private volatile int _failures = 0;
    private volatile int _successes = 0;
    private volatile int _notRun = 0;
    private int _weight = 100;
    private float _floatWeight = this._weight;
    private int _originalWeight = this._weight;
    private float _inertia = 1.0f;
    private int _maxInvocations = 0;
    private List<Task> _followers = Collections.emptyList();
    private long _runFrom = 0L;
    private long _stopAfter = Long.MAX_VALUE;
    private int _maxTime = -1;

    @Override
    public final void executeTask() throws Throwable {
        try {
            this.doExecuteTask();
            ++this._successes;
            if (this._inertia != 1.0f) {
                this.reCalculateWeight();
            }
        }
        catch (TaskNotRunException e) {
            ++this._notRun;
            throw e;
        }
        catch (Throwable throwable) {
            ++this._failures;
            throw throwable;
        }
    }

    protected abstract void doExecuteTask() throws Throwable;

    @Override
    public final void reset() {
        this._failures = 0;
        this._notRun = 0;
        this._successes = 0;
        this._weight = this._originalWeight;
        this._floatWeight = this._weight;
    }

    @Override
    public final int getWeight() {
        return this._weight;
    }

    @Override
    public final float getInertia() {
        return this._inertia;
    }

    @Override
    public final void setInertia(float inertia) {
        this._inertia = inertia;
    }

    @Override
    public final void setWeight(int weight) {
        this._weight = weight;
        this._floatWeight = this._weight;
        this._originalWeight = weight;
        this._floatWeight = weight;
    }

    @Override
    public final void setMaxInvocations(int maxInvocations) {
        this._maxInvocations = maxInvocations;
    }

    @Override
    public final int getMaxInvocations() {
        return this._maxInvocations;
    }

    @Override
    public final int getInvocations() {
        return this._successes + this._failures;
    }

    @Override
    public final int getFailures() {
        return this._failures;
    }

    @Override
    public final int getSuccesses() {
        return this._successes;
    }

    @Override
    public final int getNotRun() {
        return this._notRun;
    }

    protected final void notRun(String reason, Throwable cause) {
        throw new TaskNotRunException(reason);
    }

    protected final void failed(String reason, Throwable cause) {
        throw new TaskFailedException(reason, cause);
    }

    protected final void failed(String reason) {
        this.failed(reason, null);
    }

    private void reCalculateWeight() {
        this._floatWeight *= this._inertia;
        this._weight = (int)this._floatWeight;
    }

    @Override
    public final List<Task> getFollowers() {
        return this._followers;
    }

    @Override
    public final void setFollowers(List<Task> followers) {
        this._followers = Collections.unmodifiableList(followers);
    }

    @Override
    public final long getRunFrom() {
        return this._runFrom;
    }

    @Override
    public final long getStopAfter() {
        return this._stopAfter;
    }

    @Override
    public final void setRunFrom(long runFrom) {
        this._runFrom = runFrom;
    }

    @Override
    public final void setStopAfter(long stopAfter) {
        this._stopAfter = stopAfter;
    }

    @Override
    public List<Phase> applicablePhases() {
        return Arrays.asList(Phase.RUN);
    }

    @Override
    public int getMaxTime() {
        return this._maxTime;
    }

    public void setMaxTime(int maxTime) {
        this._maxTime = maxTime;
    }

    public final void setLog(Log log) {
        this._log = log;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public final String toString() {
        return "AbstractTask{_failures=" + this._failures + ", _successes=" + this._successes + ", _notRun=" + this._notRun + ", _weight=" + this._weight + ", _floatWeight=" + this._floatWeight + ", _inertia=" + this._inertia + ", _maxInvocations=" + this._maxInvocations + ", _followers=" + this._followers + "}";
    }
}

