/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.tasks;

import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.tasks.AbstractTask;

public class ThreadIncrementTask
extends AbstractTask {
    private Scheduler _scheduler;
    private int _threadIncrementCount = 0;

    public void setScheduler(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public void setThreadIncrementCount(int threadIncrementCount) {
        this._threadIncrementCount = threadIncrementCount;
    }

    public void doExecuteTask() throws Throwable {
        if (this._threadIncrementCount == 0) {
            return;
        }
        this._log.info((Object)("Thread increment of '" + this._threadIncrementCount + "' thread(s)"));
        try {
            this._log.debug((Object)("Incrementing thread count by '" + this._threadIncrementCount + "'"));
            this._scheduler.addThreads(this._threadIncrementCount);
        }
        catch (Throwable e) {
            this._log.error((Object)e.getMessage(), e);
        }
    }

    public int getMaxTime() {
        return 0;
    }
}

