/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.internal.TimedTaskInvoker;
import net.sourceforge.basher.internal.impl.SimpleTimerTask;
import net.sourceforge.basher.internal.impl.TimedTaskInvokerInfo;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedTaskInvokerImpl
implements TimedTaskInvoker,
BasherEventListener {
    private Log _logger;
    private List<TimedTaskInvokerInfo> _timedTaskInfos;
    private boolean _started = false;
    public Timer _timer;

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void setTimedTaskInfos(List<TimedTaskInvokerInfo> timedTaskInfos) {
        this._timedTaskInfos = timedTaskInfos;
    }

    @Override
    public boolean isRunning() {
        return this._started;
    }

    @Override
    public void start() {
        if (this._started) {
            throw new IllegalStateException("Already started");
        }
        if (this._timedTaskInfos != null && !this._timedTaskInfos.isEmpty()) {
            this._timer = new Timer(false);
            this._logger.info((Object)"Timed Task Executor Starting");
            int count = 0;
            for (TimedTaskInvokerInfo timedExecutorInfo : this._timedTaskInfos) {
                if (timedExecutorInfo.getInterval() * 1000L < 1000L) {
                    this._logger.warn((Object)("Timed task '" + timedExecutorInfo.getTimedTask().getName() + "' will not be run as interval is < 1 sec"));
                    continue;
                }
                this._logger.debug((Object)("Starting timed task '" + timedExecutorInfo.getTimedTask().getName() + "'"));
                this._timer.scheduleAtFixedRate((TimerTask)new SimpleTimerTask(timedExecutorInfo.getTimedTask(), this._logger), timedExecutorInfo.getInterval() * 1000L, timedExecutorInfo.getInterval() * 1000L);
                ++count;
            }
            this._logger.info((Object)("Timed Task Executors started.  " + count + " timed task(s) running"));
        } else {
            this._logger.info((Object)"No timed tasks to start");
        }
        this._started = true;
    }

    @Override
    public void stop() {
        if (!this._started) {
            throw new IllegalStateException("Not started");
        }
        this._logger.info((Object)"Stopping Timed Task Executor");
        this._timer.cancel();
        this._timer.purge();
        this._logger.info((Object)"Timed Task Executor Stopped");
        this._started = false;
    }

    @Override
    public void basherEvent(BasherEvent basherEvent) {
        if (basherEvent instanceof PhaseTransitionEvent) {
            if (((PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.RUN) {
                this.start();
            }
            if (((PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.COOLDOWN) {
                this.stop();
            }
        }
    }
}

