/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.basher.Basher;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.TaskManager;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.NoTasksAvailableEvent;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.events.TasksAvailableEvent;
import net.sourceforge.basher.events.ThreadRemovedEvent;
import net.sourceforge.basher.internal.Randomizer;
import net.sourceforge.basher.internal.TaskInvoker;
import net.sourceforge.basher.internal.TaskRunner;
import org.apache.commons.logging.Log;
import org.ops4j.gaderian.events.RegistryShutdownListener;

public class TaskRunnerImpl
implements TaskRunner,
BasherEventListener,
RegistryShutdownListener {
    private Randomizer _randomizer;
    private TaskManager _taskManager;
    private TaskInvoker _taskInvoker;
    private Log _logger;
    private int _minTime;
    private int _maxDelay;
    private Set<String> _threadsShutdown = new HashSet<String>();
    private Semaphore _semaphore = new Semaphore(0);
    private AtomicBoolean _keepRunning = new AtomicBoolean(true);
    public int _initialNumberThreads = 0;

    public void setRandomizer(Randomizer randomizer) {
        this._randomizer = randomizer;
    }

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void setTaskInvoker(TaskInvoker taskInvoker) {
        this._taskInvoker = taskInvoker;
    }

    public void stopInvoking() {
        this._keepRunning.set(false);
    }

    public void run() {
        while (this.keepProcessing()) {
            try {
                Task task = this._taskManager.getNextRandomTask();
                if (task != null) {
                    this._taskInvoker.invokeTask(task);
                }
                if (!this._keepRunning.get()) continue;
                Basher.fireCleanUpThread();
                Thread.sleep(this.getRandomSleepTime());
            }
            catch (Exception e) {
                this._logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean keepProcessing() {
        try {
            this._semaphore.acquire();
            try {
                String threadName = Thread.currentThread().getName();
                if (this._threadsShutdown.contains(threadName)) {
                    this._threadsShutdown.remove(threadName);
                    this._semaphore.acquire();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this._keepRunning.get();
                return bl;
            }
            finally {
                this._semaphore.release();
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private long getRandomSleepTime() {
        return this._minTime + this._randomizer.getRandomInt(this._maxDelay);
    }

    public void basherEvent(BasherEvent basherEvent) {
        if (basherEvent instanceof PhaseTransitionEvent) {
            PhaseTransitionEvent phaseTransitionEvent = (PhaseTransitionEvent)basherEvent;
            this._maxDelay = phaseTransitionEvent.getBasherContext().getTaskMaxDelay();
            this._minTime = phaseTransitionEvent.getBasherContext().getTaskMinDelay();
            this._initialNumberThreads = phaseTransitionEvent.getBasherContext().getInitialNumberThreads();
            switch (phaseTransitionEvent.getNewPhase()) {
                case SETUP: {
                    break;
                }
                case RUN: {
                    this._semaphore.release(this._initialNumberThreads);
                    break;
                }
                case COOLDOWN: 
                case TEARDOWN: {
                    try {
                        this._semaphore.acquire(this._semaphore.availablePermits());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case END: {
                    this.stopInvoking();
                }
            }
        } else if (basherEvent instanceof ThreadRemovedEvent) {
            String threadName = ((ThreadRemovedEvent)basherEvent).getName();
            if (!this._threadsShutdown.contains(threadName)) {
                this._logger.info((Object)("Thread " + threadName + " shutting down on request"));
                this._threadsShutdown.add(threadName);
            }
        } else if (basherEvent instanceof NoTasksAvailableEvent) {
            this.flipProcessing(false);
        } else if (basherEvent instanceof TasksAvailableEvent) {
            this.flipProcessing(true);
        }
    }

    private void flipProcessing(boolean state) {
        if (state) {
            this._semaphore.release(this._initialNumberThreads);
        } else {
            try {
                this._semaphore.acquire(this._initialNumberThreads);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void registryDidShutdown() {
        this.stopInvoking();
    }
}

