/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import net.sourceforge.basher.Collector;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.TaskManager;
import net.sourceforge.basher.TaskNotRunException;
import net.sourceforge.basher.internal.Randomizer;
import net.sourceforge.basher.internal.TaskInvoker;
import net.sourceforge.basher.internal.TimeSource;
import org.apache.commons.logging.Log;

public class TaskInvokerImpl
implements TaskInvoker {
    private Randomizer _randomizer;
    private Collector _collector;
    private Log _logger;
    private TaskManager _taskManager;
    private TimeSource _timeSource;

    public void setTimeSource(TimeSource timeSource) {
        this._timeSource = timeSource;
    }

    public void setLog(Log log) {
        this._logger = log;
    }

    public void setRandomizer(Randomizer randomizer) {
        this._randomizer = randomizer;
    }

    public void setCollector(Collector collector) {
        this._collector = collector;
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void invokeTask(Task task) {
        this.doInvokeTask(task, true);
    }

    public void invokeTask(Task task, boolean invokeFollowers) {
        this.doInvokeTask(task, invokeFollowers);
    }

    private void doInvokeTask(Task task, boolean invokeFollower) {
        int weight;
        int invocations = task.getInvocations();
        if (task.getMaxInvocations() != 0 && invocations >= task.getMaxInvocations()) {
            this._logger.debug((Object)("Not running task: " + task.getName() + " (max invocations reached)"));
            this._taskManager.removeTask(task);
            return;
        }
        long currentTime = this._timeSource.getElapsedTime() / 1000L;
        if (currentTime < task.getRunFrom() || currentTime > task.getStopAfter()) {
            this._logger.debug((Object)("Not running task " + task.getName() + " (not within time boundary " + currentTime + "/" + task.getRunFrom() + "/" + task.getStopAfter() + ")"));
            this._collector.notRun(task, 0L);
            return;
        }
        int weigher = this._randomizer.getRandomInt(100);
        if (weigher < (weight = task.getWeight())) {
            long startTime = this._timeSource.getCurrentTime();
            try {
                this._logger.debug((Object)("Invoking task: " + task.getName()));
                task.executeTask();
                if (invokeFollower && task.getFollowers().size() != 0) {
                    this._logger.debug((Object)"Invoking followers");
                    for (Task follower : task.getFollowers()) {
                        this.invokeTask(follower, false);
                    }
                }
                this._collector.success(task, this._timeSource.getCurrentTime() - startTime);
            }
            catch (TaskNotRunException e) {
                this._logger.debug((Object)("Task not run: " + task.getName() + " (" + e.getMessage() + ")"));
                this._collector.notRun(task, this._timeSource.getCurrentTime() - startTime);
            }
            catch (Throwable throwable) {
                this._logger.debug((Object)("Task failed: " + task.getName()), throwable);
                this._collector.fail(task, this._timeSource.getCurrentTime() - startTime, throwable);
            }
        } else {
            this._logger.debug((Object)("Not running task: " + task.getName() + " (weigth: " + weight + " / weigher: " + weigher + ")"));
            this._collector.notRun(task, 0L);
        }
    }
}

