/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sourceforge.basher.BasherException;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.annotations.BasherExecuteMethod;
import net.sourceforge.basher.annotations.BasherInertia;
import net.sourceforge.basher.annotations.BasherMaxInvocations;
import net.sourceforge.basher.annotations.BasherMaxTime;
import net.sourceforge.basher.annotations.BasherName;
import net.sourceforge.basher.annotations.BasherNotPhaseCooldown;
import net.sourceforge.basher.annotations.BasherNotPhaseRun;
import net.sourceforge.basher.annotations.BasherNotPhaseSetup;
import net.sourceforge.basher.annotations.BasherPhaseCooldown;
import net.sourceforge.basher.annotations.BasherPhaseRun;
import net.sourceforge.basher.annotations.BasherPhaseSetup;
import net.sourceforge.basher.annotations.BasherRunFrom;
import net.sourceforge.basher.annotations.BasherStopAfter;
import net.sourceforge.basher.annotations.BasherWeight;
import net.sourceforge.basher.internal.TaskDecorator;
import net.sourceforge.basher.internal.impl.DecoratedTask;
import org.apache.commons.logging.Log;
import org.ops4j.gaderian.service.BodyBuilder;
import org.ops4j.gaderian.service.ClassFab;
import org.ops4j.gaderian.service.ClassFactory;
import org.ops4j.gaderian.service.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDecoratorImpl
implements TaskDecorator {
    private ClassFactory _classFactory;
    private Log _log;

    public void setLog(Log log) {
        this._log = log;
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    @Override
    public Task decorateInstance(Object taskInstance) {
        try {
            String taskInstanceClassName = taskInstance.getClass().getName();
            String className = taskInstanceClassName.substring(taskInstanceClassName.lastIndexOf(46));
            String taskClassName = className + "BasherDecoratedTask";
            String executionMethodName = this.determineExecutionMethodName(taskInstance);
            DecoratedTask decoratedTask = this.createDecoratedTask(taskClassName, executionMethodName, taskInstance);
            this.initializeTask(taskInstance, decoratedTask);
            return decoratedTask;
        }
        catch (Exception e) {
            throw new BasherException(e.getMessage(), e);
        }
    }

    private void initializeTask(Object taskInstance, DecoratedTask decoratedTask) {
        Class<?> taskInstanceClass = taskInstance.getClass();
        this.processAnnotations(taskInstanceClass, decoratedTask);
    }

    private void processAnnotations(Class<? extends Object> taskInstanceClass, DecoratedTask decoratedTask) {
        Annotation annotation;
        Class<? extends Object> superClass = taskInstanceClass.getSuperclass();
        if (!superClass.equals(Object.class)) {
            this.processAnnotations(superClass, decoratedTask);
        }
        if (taskInstanceClass.isAnnotationPresent(BasherMaxTime.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherMaxTime.class);
            decoratedTask.setMaxTime(annotation.time());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherMaxInvocations.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherMaxInvocations.class);
            decoratedTask.setMaxInvocations(annotation.max());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherInertia.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherInertia.class);
            decoratedTask.setInertia(annotation.inertia());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherName.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherName.class);
            decoratedTask.setName(annotation.name());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherStopAfter.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherStopAfter.class);
            decoratedTask.setStopAfter(annotation.time());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherWeight.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherWeight.class);
            decoratedTask.setWeight(annotation.weight());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherRunFrom.class)) {
            annotation = taskInstanceClass.getAnnotation(BasherRunFrom.class);
            decoratedTask.setRunFrom(annotation.time());
        }
        if (taskInstanceClass.isAnnotationPresent(BasherNotPhaseRun.class)) {
            decoratedTask.removePhase(Phase.RUN);
        }
        if (taskInstanceClass.isAnnotationPresent(BasherNotPhaseSetup.class)) {
            decoratedTask.removePhase(Phase.SETUP);
        }
        if (taskInstanceClass.isAnnotationPresent(BasherNotPhaseCooldown.class)) {
            decoratedTask.removePhase(Phase.COOLDOWN);
        }
        if (taskInstanceClass.isAnnotationPresent(BasherPhaseRun.class)) {
            decoratedTask.addPhase(Phase.RUN);
        }
        if (taskInstanceClass.isAnnotationPresent(BasherPhaseSetup.class)) {
            decoratedTask.addPhase(Phase.SETUP);
        }
        if (taskInstanceClass.isAnnotationPresent(BasherPhaseCooldown.class)) {
            decoratedTask.addPhase(Phase.COOLDOWN);
        }
        if (decoratedTask.applicablePhases().size() == 0) {
            this._log.warn((Object)"No applicable phase specified for task");
        }
    }

    private DecoratedTask createDecoratedTask(String taskClassName, String executionMethodName, Object taskInstance) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        ClassFab fab = this._classFactory.newClass(taskClassName, DecoratedTask.class);
        fab.addField("_taskInstance", taskInstance.getClass());
        BodyBuilder bodyBuilder = new BodyBuilder();
        bodyBuilder.begin();
        bodyBuilder.addln("_taskInstance." + executionMethodName + "();");
        bodyBuilder.end();
        fab.addMethod(1, new MethodSignature(Void.TYPE, "exectuteTask", new Class[0], new Class[]{Throwable.class}), bodyBuilder.toString());
        bodyBuilder.clear();
        bodyBuilder.begin();
        bodyBuilder.addln("super();");
        bodyBuilder.addln("_taskInstance = $1;");
        bodyBuilder.end();
        fab.addConstructor(new Class[]{taskInstance.getClass()}, new Class[0], bodyBuilder.toString());
        Class decoratedTask = fab.createClass();
        Constructor constructor = decoratedTask.getConstructor(taskInstance.getClass());
        return (DecoratedTask)constructor.newInstance(taskInstance);
    }

    String determineExecutionMethodName(Object taskInstance) {
        Method[] methods = taskInstance.getClass().getMethods();
        Method selectedMethod = null;
        for (Method method : methods) {
            if (method.getAnnotation(BasherExecuteMethod.class) == null) continue;
            if (selectedMethod == null) {
                selectedMethod = method;
                continue;
            }
            throw new BasherException("Found more than 1 execute method", null);
        }
        if (selectedMethod != null) {
            this.validateExecutionMethod(selectedMethod);
            return selectedMethod.getName();
        }
        try {
            taskInstance.getClass().getMethod("executeTask", new Class[0]);
            return "executeTask";
        }
        catch (NoSuchMethodException e) {
            throw new BasherException("Could not find executeTask", e);
        }
    }

    private void validateExecutionMethod(Method method) {
        if (method.getParameterTypes().length != 0) {
            throw new BasherException("Execution method '" + method.getName() + "' requires parameters", null);
        }
    }
}

