/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import bsh.Interpreter;
import net.sourceforge.basher.BasherException;
import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.TaskManager;
import org.apache.commons.logging.Log;
import org.ops4j.gaderian.events.RegistryShutdownListener;

public class BeanShellServer
implements RegistryShutdownListener {
    private Scheduler _scheduler;
    private Log _log;
    private TaskManager _taskManager;
    private int _port;
    private Interpreter _interpreter;

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void setScheduler(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void initializeService() throws Exception {
        this._log.info((Object)"Basher BeanShell Server starting");
        try {
            this._interpreter = new Interpreter();
            this._interpreter.set("scheduler", (Object)this._scheduler);
            this._interpreter.set("taskManager", (Object)this._taskManager);
            this._interpreter.eval("static import net.sourceforge.basher.internal.impl.BeanShellHelper.*");
            this._interpreter.set("portnum", this._port);
            this._interpreter.eval("setAccessibility(true)");
            this._interpreter.eval("server(portnum)");
        }
        catch (Throwable throwable) {
            String errorMessage = "Unable to start the Basher Beanshell Server on port " + this._port;
            this._log.error((Object)errorMessage);
            this._log.error((Object)("Eror: " + throwable.getMessage()));
            throw new BasherException(errorMessage, throwable);
        }
        this._log.info((Object)("Basher BeanShell Server started on port " + this._port));
    }

    public void registryDidShutdown() {
    }
}

