/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.TaskManager;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.internal.BeanShellInitializer;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellInitializerImpl
implements BeanShellInitializer,
BasherEventListener {
    private TaskManager _taskManager;
    private Log _logger;
    private Scheduler _scheduler;
    private FilenameFilter _filenameFilter;
    private Comparator<File> _filenameComparator;

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filenameFilter = filenameFilter;
    }

    public void setFilenameComparator(Comparator<File> filenameComparator) {
        this._filenameComparator = filenameComparator;
    }

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void setScheduler(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    private void executeScripts(File scriptDirectory) throws Exception {
        if (!scriptDirectory.exists()) {
            throw new Exception("Script directory '" + scriptDirectory.getAbsolutePath() + "' does not exist");
        }
        if (!scriptDirectory.canRead()) {
            throw new Exception("Read access denied to script directory '" + scriptDirectory.getAbsolutePath() + "'");
        }
        this._logger.info((Object)("Using script directory " + scriptDirectory.getAbsolutePath()));
        File[] scriptFiles = scriptDirectory.listFiles(this._filenameFilter);
        ArrayList<File> scriptFileList = new ArrayList<File>(Arrays.asList(scriptFiles));
        Collections.sort(scriptFileList, this._filenameComparator);
        this._logger.debug((Object)("Executing " + scriptFileList.size() + " script(s)"));
        for (File scriptFile : scriptFileList) {
            this._logger.debug((Object)("Executing " + scriptFile.getName()));
            Interpreter interpreter = new Interpreter();
            interpreter.set("taskManager", (Object)this._taskManager);
            interpreter.set("scheduler", (Object)this._scheduler);
            FileReader reader = new FileReader(scriptFile);
            try {
                interpreter.eval((Reader)reader);
                this._logger.debug((Object)(scriptFile.getName() + " executed successfully"));
            }
            catch (EvalError evalError) {
                this._logger.error((Object)evalError.getMessage(), (Throwable)evalError);
            }
        }
    }

    @Override
    public void basherEvent(BasherEvent basherEvent) {
        PhaseTransitionEvent phaseTransitionEvent;
        if (basherEvent instanceof PhaseTransitionEvent && (phaseTransitionEvent = (PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.START) {
            try {
                String beanshellScriptDirectory = phaseTransitionEvent.getBasherContext().getBeanShellScriptDirectory();
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("Executing scripts in: " + beanshellScriptDirectory));
                }
                this.executeScripts(new File(beanshellScriptDirectory));
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)"Scripts execution completed");
                }
            }
            catch (Exception e) {
                this._logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

