/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.internal.impl;

import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.ContextManager;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.EventManager;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import org.ops4j.gaderian.Registry;
import org.ops4j.gaderian.impl.RegistryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasherBootHelper
implements BasherEventListener {
    private Registry _registry;
    private CountDownLatch countDownLatch = new CountDownLatch(1);

    public int run(String activeBasherContext, Properties properties, Boolean failIfNoTasks) {
        this._registry = RegistryBuilder.constructDefaultRegistry();
        BasherContext basherContext = this.initializeBasherContexts(activeBasherContext, properties);
        EventManager eventManager = (EventManager)this._registry.getService(EventManager.class);
        eventManager.addBasherEventListener(this);
        if (basherContext.isAwaitStartSignal()) {
            ContextManager contextManager = (ContextManager)this._registry.getService(ContextManager.class);
            contextManager.addBasherContext(basherContext);
        } else {
            Scheduler scheduler = (Scheduler)this._registry.getService(Scheduler.class);
            scheduler.start(basherContext);
        }
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            return 1;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this._registry.shutdown();
        return 0;
    }

    private BasherContext initializeBasherContexts(String activeBasherContext, Properties properties) {
        List<BasherContext> basherContexts = this.deserializeBasherContexts(properties);
        ContextManager contextManager = (ContextManager)this._registry.getService(ContextManager.class);
        for (BasherContext basherContext : basherContexts) {
            contextManager.addBasherContext(basherContext);
        }
        BasherContext context = contextManager.getBasherContext(activeBasherContext);
        this.setupReportsDirecotory(context, properties);
        return context;
    }

    private void setupReportsDirecotory(BasherContext basherContext, Properties properties) {
        basherContext.setReportDirectory(properties.getProperty("reportingDirectory", "target/basher-reports"));
    }

    private List<BasherContext> deserializeBasherContexts(Properties properties) {
        ArrayList<BasherContext> basherContexts = new ArrayList<BasherContext>();
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (!key.startsWith("basherContext.")) continue;
            XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(properties.getProperty(key).getBytes()));
            BasherContext basherContext = (BasherContext)xmlDecoder.readObject();
            basherContexts.add(basherContext);
        }
        return basherContexts;
    }

    @Override
    public void basherEvent(BasherEvent basherEvent) {
        if (basherEvent instanceof PhaseTransitionEvent && ((PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.END) {
            this.countDownLatch.countDown();
        }
    }
}

