/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.util.Formatter;
import net.sourceforge.basher.Average;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.impl.AbstractFileCollector;

public class XMLFileCollector
extends AbstractFileCollector
implements BasherEventListener {
    final String EXECUTION_TEMPLATE = "<execution mark=\"%d\" time=\"%d\"/>\n";
    final String AVERAGE_TEMPLATE = "<average mark=\"%d\" min=\"%d\" max=\"%d\" totaltime=\"%d\" totalentries=\"%d\" average=\"%d\" tps=\"%f\" threads=\"%d\"/>\n";

    public void initializeService() throws Exception {
        super.initializeService();
        this.setAverageHeader("<averages>\n");
        this.setAverageFooter("</averages>");
        this.setExecutionHeader("<executions taskname=\"%s\">\n");
        this.setExecutionFooter("</executions>");
    }

    protected String formatAverage(Average average) {
        StringBuffer sb = new StringBuffer();
        Formatter formatter = new Formatter(sb);
        formatter.format("<average mark=\"%d\" min=\"%d\" max=\"%d\" totaltime=\"%d\" totalentries=\"%d\" average=\"%d\" tps=\"%f\" threads=\"%d\"/>\n", this._timeSource.getElapsedTime(), average.getMinTime(), average.getMaxTime(), average.getTotalTime(), average.getTotalEntries(), average.getAverage(), Float.valueOf(average.getTPS()), average.getNumThreads());
        return sb.toString();
    }

    protected String formatExecution(String taskName, long elapsedTime) {
        StringBuffer sb = new StringBuffer();
        Formatter formatter = new Formatter(sb);
        formatter.format("<execution mark=\"%d\" time=\"%d\"/>\n", this._timeSource.getElapsedTime(), elapsedTime);
        return sb.toString();
    }

    public void basherEvent(BasherEvent basherEvent) {
        super.basherEvent(basherEvent);
    }
}

