/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.TaskManager;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.EventManager;
import net.sourceforge.basher.events.NoTasksAvailableEvent;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.events.TasksAvailableEvent;
import net.sourceforge.basher.impl.TaskInfo;
import net.sourceforge.basher.internal.Randomizer;
import net.sourceforge.basher.internal.TaskCreator;
import net.sourceforge.basher.internal.TaskDecorator;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerImpl
implements TaskManager,
BasherEventListener {
    private List<TaskInfo> _taskInfos;
    private List<Task> _tasks;
    private List<Task> _availableTasks;
    private Randomizer _randomizer;
    private List<Task> _removedTasks;
    private Log _logger;
    public final List<Task> EMPTY_TASK_LIST = Collections.emptyList();
    private EventManager _eventManager;
    private TaskCreator _taskCreator;
    private TaskDecorator _taskDecorator;

    public void setTaskCreator(TaskCreator taskCreator) {
        this._taskCreator = taskCreator;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this._taskDecorator = taskDecorator;
    }

    public void setEventManager(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void setRandomizer(Randomizer randomizer) {
        this._randomizer = randomizer;
    }

    @Override
    public synchronized void addTask(Task task) {
        this.checkInitialized();
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this._removedTasks.contains(task)) {
            this._removedTasks.remove(task);
        }
        this._tasks.add(task);
        this._logger.info((Object)("Task '" + task.getName() + "' added"));
        this._eventManager.publish(new TasksAvailableEvent());
    }

    @Override
    public Task addTaskClass(Class taskClassName, Task ... followers) {
        Task task = this._taskCreator.createTask(taskClassName);
        task.setFollowers(Arrays.asList(followers));
        this.addTask(task);
        return task;
    }

    @Override
    public Task addTaskInstance(Object taskInstance, Task ... followers) {
        Task task = this._taskDecorator.decorateInstance(taskInstance);
        task.setFollowers(Arrays.asList(followers));
        this.addTask(task);
        return task;
    }

    @Override
    public Task getNextRandomTask() {
        this.checkInitialized();
        if (this._availableTasks.size() == 0) {
            this._logger.debug((Object)"No active tasks available");
            return null;
        }
        int nextRandom = this._randomizer.getRandomInt(this._availableTasks.size());
        return this._availableTasks.get(nextRandom);
    }

    @Override
    public List<Task> getTasks() {
        this.checkInitialized();
        return Collections.unmodifiableList(this._availableTasks);
    }

    @Override
    public List<Task> getRegisteredTasks() {
        this.checkInitialized();
        return Collections.unmodifiableList(this._tasks);
    }

    @Override
    public Task getTaskByName(String name) {
        this.checkInitialized();
        for (Task task : this._tasks) {
            if (!task.getName().equals(name)) continue;
            return task;
        }
        for (Task removedTask : this._removedTasks) {
            if (!removedTask.getName().equals(name)) continue;
            return removedTask;
        }
        return null;
    }

    @Override
    public void removeTask(Task task) {
        this.checkInitialized();
        if (this._availableTasks.contains(task)) {
            this._logger.info((Object)("Removing task '" + task.getName() + "' from active list"));
            this._availableTasks.remove(task);
            this._removedTasks.add(task);
            if (this._tasks.size() == 0) {
                this._eventManager.publish(new NoTasksAvailableEvent());
            }
        } else {
            this._logger.warn((Object)("Task '" + task.getName() + "' not in active list, can not remove"));
        }
    }

    @Override
    public List<Task> getRemovedTasks() {
        this.checkInitialized();
        return Collections.unmodifiableList(this._removedTasks);
    }

    private void checkInitialized() {
        if (this._tasks == null) {
            throw new IllegalStateException("not initialized");
        }
    }

    @Override
    public int getNumberOfRemovedTasks() {
        this.checkInitialized();
        return this._removedTasks.size();
    }

    @Override
    public int getNumberOfTasks() {
        this.checkInitialized();
        return this._availableTasks.size();
    }

    public void setTaskInfos(List<TaskInfo> taskInfos) {
        if (taskInfos == null) {
            throw new NullPointerException("taskInfos");
        }
        this._taskInfos = taskInfos;
    }

    public void initializeService() {
        if (this._randomizer == null) {
            throw new IllegalStateException("no randomizer");
        }
        if (this._logger == null) {
            throw new IllegalStateException("no log");
        }
        this._removedTasks = new ArrayList<Task>();
        this._tasks = new ArrayList<Task>();
        this._availableTasks = new ArrayList<Task>();
        if (this._taskInfos != null) {
            if (this._taskInfos.size() == 0) {
                this._logger.warn((Object)"No TaskInfo instances supplied");
                return;
            }
            for (TaskInfo taskInfo : this._taskInfos) {
                Task task = taskInfo.getTask();
                if (taskInfo.getFollowers() != null && taskInfo.getFollowers().size() > 0) {
                    task.setFollowers(taskInfo.getFollowers());
                } else {
                    task.setFollowers(this.EMPTY_TASK_LIST);
                }
                this._tasks.add(task);
                this._logger.debug((Object)("Task '" + task.getName() + "' added - " + task.getFollowers().size() + " follower(s)"));
            }
            this._logger.info((Object)("'" + this._tasks.size() + "' task(s) added"));
        } else {
            this._logger.warn((Object)"No TaskInfo instances supplied");
        }
    }

    @Override
    public void basherEvent(BasherEvent basherEvent) {
        if (basherEvent instanceof PhaseTransitionEvent) {
            PhaseTransitionEvent phaseTransitionEvent = (PhaseTransitionEvent)basherEvent;
            Phase newPhase = phaseTransitionEvent.getNewPhase();
            this.sortAvailableTasks(newPhase);
        }
    }

    void sortAvailableTasks(Phase newPhase) {
        this._removedTasks.clear();
        this._availableTasks.clear();
        for (Task task : this._tasks) {
            if (!task.applicablePhases().contains((Object)newPhase)) continue;
            this._availableTasks.add(task);
        }
    }
}

