/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import net.sourceforge.basher.Average;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.Collector;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.impl.AbstractCollector;

public class StdOutCollector
extends AbstractCollector
implements Collector {
    protected void initializeCollector(BasherContext basherContext) throws Exception {
        System.out.println("Initializing StdOut Collector with Basher Context: " + basherContext.getName());
    }

    public void success(Task task, long elapsedTime) {
        super.success(task, elapsedTime);
        if (this.isCollecting()) {
            System.out.format("task: %s finished in %d millisecond(s)", task.getName(), elapsedTime);
        }
    }

    public void notRun(Task task, long elapsedTime) {
        super.notRun(task, elapsedTime);
    }

    public void fail(Task task, long elapsedTime, Throwable throwable) {
        super.fail(task, elapsedTime, throwable);
        if (this.isCollecting()) {
            System.out.format("task: %s failed due to %s", task.getName(), throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public Average markAverage() {
        Average average = super.markAverage();
        if (this.isCollecting()) {
            System.out.println(average);
        }
        return average;
    }
}

