/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.ContextManager;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.CollectionStartedEvent;
import net.sourceforge.basher.events.CollectionStoppedEvent;
import net.sourceforge.basher.events.EventManager;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.events.ThreadAddedEvent;
import net.sourceforge.basher.events.ThreadRemovedEvent;
import net.sourceforge.basher.impl.EventEmitterTimerTask;
import net.sourceforge.basher.impl.TickTimerTask;
import net.sourceforge.basher.internal.TaskRunner;
import org.apache.commons.logging.Log;

public class SchedulerImpl
implements Scheduler,
BasherEventListener {
    private Log _logger;
    private ContextManager _contextManager;
    private EventManager _eventManager;
    private TaskRunner _taskRunner;
    private List<String> _threadNames;
    private ThreadGroup _threadGroup;
    private int _threadCounter = 0;
    private Timer _timer = new Timer();
    private boolean _running = false;

    public synchronized void addThread() {
        this.checkInitialized();
        this.addNewThread(this._contextManager.getActiveBasherContext());
    }

    public void addThreads(int numToAdd) {
        this.checkInitialized();
        this._logger.debug((Object)("Adding " + numToAdd + " thread(s)"));
        for (int i = 0; i < numToAdd; ++i) {
            this.addThread();
        }
        this._logger.debug((Object)(numToAdd + " thread(s) added"));
    }

    public synchronized void removeThread() {
        this.checkInitialized();
        if (this._threadNames.size() > 0) {
            this._logger.debug((Object)"Removing thread from active list");
            String threadName = this._threadNames.remove(0);
            this._logger.debug((Object)("Thread " + threadName + " removed from active list"));
            this._logger.debug((Object)("Signalling stop thread for thread named: " + threadName));
            this._eventManager.publish(new ThreadRemovedEvent(threadName));
            this._logger.debug((Object)"Thread stop signalled");
        } else {
            this._logger.warn((Object)"No threads to remove");
        }
    }

    public void removeAllThreads() {
        this.checkInitialized();
        int threadsToRemove = this._threadNames.size();
        this._logger.debug((Object)("Removing " + threadsToRemove + " thread(s)"));
        for (int i = 0; i < threadsToRemove; ++i) {
            this.removeThread();
        }
        this._logger.debug((Object)(threadsToRemove + " thread(s) removed"));
    }

    public void stop() {
        this.stopInternal(false);
    }

    private void stopInternal(boolean calledFromEvent) {
        this.checkStopPrecondition();
        this._logger.info((Object)"Stopping scheduler");
        if (!calledFromEvent) {
            this._eventManager.publish(new PhaseTransitionEvent(this._contextManager.getActiveBasherContext(), Phase.RUN, Phase.END));
        }
        this._threadGroup = null;
        this._threadNames.clear();
        this._timer.cancel();
        this._timer = new Timer();
        this._running = false;
        this._logger.info((Object)"Scheduler stopped");
    }

    public void start() {
        this.start("default");
    }

    public void start(String contextName) {
        if (contextName == null) {
            throw new NullPointerException("contextName");
        }
        this.checkStartPrecondition();
        BasherContext basherContext = this.lookupBasherContext(contextName);
        if (basherContext == null) {
            throw new IllegalArgumentException("The context specified by '" + contextName + "' could not be found");
        }
        this.start(basherContext);
    }

    public void start(BasherContext basherContext) {
        if (basherContext == null) {
            throw new NullPointerException("basherContext");
        }
        this.checkStartPrecondition();
        this._logger.info((Object)("Starting scheduler with context: " + basherContext.getName()));
        this._eventManager.publish(new PhaseTransitionEvent(basherContext, null, Phase.START));
        this._threadGroup = new ThreadGroup("Basher Threads");
        this._threadNames = new ArrayList<String>();
        for (int i = 0; i < basherContext.getInitialNumberThreads(); ++i) {
            this.addNewThread(basherContext);
        }
        int numPurged = this._timer.purge();
        this._logger.debug((Object)("Purged " + numPurged + " old timer tasks"));
        this._contextManager.setActiveBasherContext(basherContext);
        this._running = true;
        this._eventManager.publish(new PhaseTransitionEvent(basherContext, Phase.START, Phase.SETUP));
        long nextEventTime = (basherContext.getSetupDuration() + 1L) * 1000L;
        this._logger.debug((Object)("Scheduling phase transition SETUP -> RUN at " + nextEventTime));
        this._timer.schedule((TimerTask)new EventEmitterTimerTask(this._eventManager, new PhaseTransitionEvent(basherContext, Phase.SETUP, Phase.RUN)), nextEventTime);
        nextEventTime = nextEventTime + 1L + basherContext.getRunDuration() * 1000L;
        this._logger.debug((Object)("Scheduling phase transition RUN -> COOLDOWN at " + nextEventTime));
        this._timer.schedule((TimerTask)new EventEmitterTimerTask(this._eventManager, new PhaseTransitionEvent(basherContext, Phase.RUN, Phase.COOLDOWN)), nextEventTime);
        nextEventTime = nextEventTime + 1L + basherContext.getCooldownDuration() * 1000L;
        this._logger.debug((Object)("Scheduling phase transition COOLDOWN -> END at " + nextEventTime));
        this._timer.schedule((TimerTask)new EventEmitterTimerTask(this._eventManager, new PhaseTransitionEvent(basherContext, Phase.COOLDOWN, Phase.END)), nextEventTime);
        this._timer.schedule((TimerTask)new EventEmitterTimerTask(this._eventManager, new CollectionStartedEvent()), (basherContext.getSetupDuration() + 1L + basherContext.getStartCollectionFrom()) * 1000L);
        this._timer.schedule((TimerTask)new EventEmitterTimerTask(this._eventManager, new CollectionStoppedEvent()), (basherContext.getSetupDuration() + 1L + basherContext.getStopCollectionAfter()) * 1000L);
        this._logger.info((Object)("Scheduler started.  " + basherContext.getInitialNumberThreads() + " thread(s) running"));
    }

    private BasherContext lookupBasherContext(String contextName) {
        return this._contextManager.getBasherContext(contextName);
    }

    public int getNumberOfActiveThreads() {
        this.checkInitialized();
        return this._threadNames.size();
    }

    public boolean isRunning() {
        return this._running;
    }

    private void addNewThread(BasherContext basherContext) {
        if (this._threadNames.size() < basherContext.getMaxNumberThreads()) {
            this._logger.debug((Object)"Adding new thread");
            String threadName = "TaskRunner-" + this._threadCounter++;
            Thread thread = new Thread(this._threadGroup, this._taskRunner, threadName);
            thread.setDaemon(true);
            thread.start();
            this._threadNames.add(threadName);
            this._logger.info((Object)("Thread added.  " + this._threadNames.size() + " thread(s) running"));
            this._eventManager.publish(new ThreadAddedEvent(threadName, basherContext));
        } else {
            this._logger.warn((Object)("Maximum thread limit (" + this._contextManager.getActiveBasherContext().getMaxNumberThreads() + ") reached, not adding more threads"));
        }
    }

    private void checkInitialized() {
        if (!this._running) {
            throw new IllegalStateException("Not started");
        }
    }

    private void checkStartPrecondition() {
        if (this._running) {
            throw new IllegalStateException("Already started");
        }
        if (this._logger == null) {
            throw new IllegalStateException("no log");
        }
        if (this._contextManager == null) {
            throw new IllegalStateException("no context manager");
        }
        if (this._eventManager == null) {
            throw new IllegalStateException("no event manager");
        }
        if (this._taskRunner == null) {
            throw new IllegalStateException("no task runner");
        }
    }

    private void checkStopPrecondition() {
        if (!this._running) {
            throw new IllegalStateException("Already stopped");
        }
    }

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void setContextManager(ContextManager contextManager) {
        this._contextManager = contextManager;
    }

    public void setEventManager(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void setTaskRunner(TaskRunner taskRunner) {
        this._taskRunner = taskRunner;
    }

    public void setTimer(Timer timer) {
        this._timer = timer;
    }

    public void basherEvent(BasherEvent basherEvent) {
        if (basherEvent instanceof PhaseTransitionEvent) {
            PhaseTransitionEvent phaseTransitionEvent = (PhaseTransitionEvent)basherEvent;
            BasherContext basherContext = phaseTransitionEvent.getBasherContext();
            switch (phaseTransitionEvent.getNewPhase()) {
                case RUN: {
                    this._timer.scheduleAtFixedRate((TimerTask)new TickTimerTask(this._eventManager), basherContext.getMarkAverageInterval() * 1000L, basherContext.getMarkAverageInterval() * 1000L);
                    break;
                }
                case COOLDOWN: {
                    break;
                }
                case END: {
                    this.stopInternal(true);
                }
            }
        }
    }
}

