/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.basher.EntityRegistry;
import net.sourceforge.basher.internal.Randomizer;
import org.apache.commons.logging.Log;

public class InMemoryEntityRegistry
implements EntityRegistry {
    private Log _logger;
    private Map _registry = new HashMap();
    private Randomizer _randomizer;

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void setRandomizer(Randomizer randomizer) {
        this._randomizer = randomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String entityIdentifier, Object entity) {
        if (entityIdentifier == null) {
            throw new NullPointerException("entityIdentifier");
        }
        if (entity == null) {
            throw new NullPointerException("entityID");
        }
        Map map = this._registry;
        synchronized (map) {
            List list = (List)this._registry.get(entityIdentifier);
            if (list == null || !list.contains(entity)) {
                this._logger.warn((Object)("Warning, entity identifier " + entity + " does not exists for type " + entityIdentifier));
                return;
            }
            list.remove(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String entityIdentifier, Object entity) {
        if (entityIdentifier == null) {
            throw new NullPointerException("entityIdentifier");
        }
        if (entity == null) {
            throw new NullPointerException("entityID");
        }
        Map map = this._registry;
        synchronized (map) {
            ArrayList<Object> list = (ArrayList<Object>)this._registry.get(entityIdentifier);
            if (list == null) {
                list = new ArrayList<Object>();
                this._registry.put(entityIdentifier, list);
            }
            list.add(entity);
        }
    }

    public Collection getAllRegistered(String entityIdentifier) {
        if (entityIdentifier == null) {
            throw new NullPointerException("entityIdentifier");
        }
        return (Collection)this._registry.get(entityIdentifier);
    }

    public long getNumRegistered(String entityIdentifier) {
        if (entityIdentifier == null) {
            throw new NullPointerException("entityIdentifier");
        }
        List list = (List)this._registry.get(entityIdentifier);
        return list == null ? 0 : list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRandomSelection(String entityIdentifier, int size) {
        Map map = this._registry;
        synchronized (map) {
            if (entityIdentifier == null) {
                throw new NullPointerException("entityIdentifier");
            }
            if (size <= 0) {
                throw new IllegalArgumentException("size <= 0");
            }
            List list = (List)this._registry.get(entityIdentifier);
            if (list == null || list.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            int realNumberToSelect = size;
            if (list.size() < size) {
                realNumberToSelect = list.size();
            }
            ArrayList selection = new ArrayList();
            for (int i = 0; i < realNumberToSelect; ++i) {
                int nextIDSlot = this._randomizer.getRandomInt(list.size());
                Object nextID = list.get(nextIDSlot);
                selection.add(nextID);
            }
            return selection;
        }
    }

    public Object getRandom(String entityIdentifier) {
        List list = (List)this.getRandomSelection(entityIdentifier, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

