/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.ContextManager;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextManagerImpl
implements ContextManager,
BasherEventListener {
    private Log _log;
    private BasherContext _activeBasherContext;
    private List<BasherContext> _basherContexts = new ArrayList<BasherContext>();

    @Override
    public BasherContext getActiveBasherContext() {
        return this._activeBasherContext;
    }

    @Override
    public void setActiveBasherContext(BasherContext basherContext) {
        this._log.debug((Object)("Setting active basher context: " + basherContext));
        this._activeBasherContext = basherContext;
    }

    @Override
    public BasherContext getBasherContext(String contextName) {
        this._log.debug((Object)("Retrieving Bascher context by name: " + contextName));
        for (BasherContext basherContext : this._basherContexts) {
            if (!basherContext.getName().equals(contextName)) continue;
            return basherContext;
        }
        throw new IllegalStateException("No such context: " + contextName);
    }

    @Override
    public List<BasherContext> getBasherContexts() {
        return this._basherContexts;
    }

    @Override
    public void addBasherContext(BasherContext basherContext) {
        if (this._basherContexts == null) {
            this._basherContexts = new ArrayList<BasherContext>();
        }
        this._basherContexts.add(basherContext);
    }

    public void setBasherContexts(List<BasherContext> basherContexts) {
        if (this._basherContexts == null) {
            this._basherContexts = basherContexts;
        } else {
            this._basherContexts.addAll(basherContexts);
        }
    }

    public void setLog(Log log) {
        this._log = log;
    }

    @Override
    public void basherEvent(BasherEvent basherEvent) {
        PhaseTransitionEvent phaseTransitionEvent;
        if (basherEvent instanceof PhaseTransitionEvent && (phaseTransitionEvent = (PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.SETUP) {
            this._activeBasherContext = phaseTransitionEvent.getBasherContext();
        }
    }
}

