/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.sourceforge.basher.Average;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.impl.AbstractCollector;
import org.ops4j.gaderian.events.RegistryShutdownListener;

public abstract class AbstractFileCollector
extends AbstractCollector
implements RegistryShutdownListener {
    protected final Map<String, OpenFile> _openFiles = new HashMap<String, OpenFile>();
    protected File _parent;
    protected String _collectionDirectory;
    private String _averageHeader = null;
    private String _averageFooter = null;
    private String _executionHeader = null;
    private String _executionFooter = null;
    private String _averageFilenamePrefix = "averages.";
    private String _extension;
    private int _queueCapacity = 200;
    private BlockingQueue<FileEntry> _fileEntries;
    private int _numThreads = 5;
    private List<FileEntryProcessor> _fileEntryProcessors;
    private long _timeOut = 500L;
    private boolean _keepRunning = true;
    private boolean _ready = true;

    public void setNumThreads(int numThreads) {
        this._numThreads = numThreads;
    }

    public void setTimeOut(long timeOut) {
        this._timeOut = timeOut;
    }

    public void setQueueCapacity(int queueCapacity) {
        this._queueCapacity = queueCapacity;
    }

    public void setAverageFooter(String averageFooter) {
        this._averageFooter = averageFooter;
    }

    public void setExecutionFooter(String executionFooter) {
        this._executionFooter = executionFooter;
    }

    public void setAverageHeader(String averageHeader) {
        this._averageHeader = averageHeader;
    }

    public void setExecutionHeader(String executionHeader) {
        this._executionHeader = executionHeader;
    }

    public void setExtension(String extension) {
        this._extension = extension;
    }

    public void setAverageFilenamePrefix(String averageFilenamePrefix) {
        this._averageFilenamePrefix = averageFilenamePrefix;
    }

    public void initializeService() throws Exception {
    }

    public void success(Task task, long elapsedTime) {
        super.success(task, elapsedTime);
        if (this._ready && this.isCollecting()) {
            this.writeToFile(Type.SUCCESS, task.getName(), elapsedTime);
        }
    }

    public void fail(Task task, long elapsedTime, Throwable throwable) {
        super.fail(task, elapsedTime, throwable);
        if (this._ready && this.isCollecting()) {
            this.writeToFile(Type.FAILURE, task.getName(), elapsedTime);
        }
    }

    protected void initializeCollector(BasherContext basherContext) throws Exception {
        try {
            this._collectionDirectory = basherContext.getReportDirectory();
            this._parent = new File(this._collectionDirectory);
            if (!this._parent.exists() && !this._parent.mkdir()) {
                throw new Exception("Could not create root collection directory '" + this._collectionDirectory + "'");
            }
            if (!this._parent.canWrite()) {
                throw new Exception("Root collection directory '" + this._collectionDirectory + "' can not be written to");
            }
            this._log.info((Object)("Initializing queue with capacity: " + this._queueCapacity));
            this._fileEntries = new ArrayBlockingQueue<FileEntry>(this._queueCapacity);
            this._fileEntryProcessors = new ArrayList<FileEntryProcessor>(this._numThreads);
            for (int i = 0; i < this._numThreads; ++i) {
                FileEntryProcessor fileEntryProcessor = new FileEntryProcessor();
                fileEntryProcessor.setName("FileEntryProcessor_" + i);
                fileEntryProcessor.setDaemon(true);
                fileEntryProcessor.start();
                this._fileEntryProcessors.add(fileEntryProcessor);
            }
            this._log.debug((Object)"AbstractFileCollector initialized");
            this._ready = true;
        }
        catch (Exception e) {
            this._log.error((Object)("Error initializing: " + e.getMessage()), (Throwable)e);
            this._log.error((Object)"Will not use filesystem");
            this._ready = false;
        }
    }

    public void notRun(Task task, long elapsedTime) {
        super.notRun(task, elapsedTime);
        if (this._ready && this.isCollecting()) {
            this.writeToFile(Type.NOT_RUN, task.getName(), elapsedTime);
        }
    }

    protected void dumpAverage(Average average) {
        try {
            String fileKey = this._averageFilenamePrefix + this._extension;
            BufferedWriter bw = this.getWriter(fileKey, Classifier.AVERAGE, new Object[0]);
            bw.write(this.formatAverage(average));
            bw.flush();
        }
        catch (IOException e) {
            this._log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected abstract String formatAverage(Average var1);

    protected abstract String formatExecution(String var1, long var2);

    protected void writeToFile(Type type, String taskName, long elapsedTime) {
        try {
            String fileKey = this.getFileName(taskName, type);
            String formattedText = this.formatExecution(taskName, elapsedTime);
            this._fileEntries.put(new FileEntry(taskName, formattedText, fileKey, Classifier.EXECUTION));
        }
        catch (Exception e) {
            this._log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getFileName(String taskName, Type type) {
        switch (type) {
            case FAILURE: {
                return taskName + "-failed." + this._extension;
            }
            case NOT_RUN: {
                return taskName + "-notrun." + this._extension;
            }
            case SUCCESS: {
                return taskName + "-success." + this._extension;
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)type));
    }

    public Average markAverage() {
        Average average = super.markAverage();
        if (this._ready && this.isCollecting()) {
            this.dumpAverage(average);
        }
        return average;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedWriter getWriter(String fileKey, Classifier classifier, Object ... headerParams) throws IOException {
        OpenFile openFile = this._openFiles.get(fileKey);
        if (openFile == null) {
            Map<String, OpenFile> map = this._openFiles;
            synchronized (map) {
                openFile = this._openFiles.get(fileKey);
                if (openFile == null) {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this._parent, fileKey)));
                    openFile = new OpenFile(bw, classifier);
                    this.addHeader(bw, classifier, headerParams);
                    bw.flush();
                    this._openFiles.put(fileKey, openFile);
                }
            }
        }
        return openFile._bufferedWriter;
    }

    public void registryDidShutdown() {
        this._log.debug((Object)"Shutting down collector");
        this.stopCollecting();
        this._log.debug((Object)("Collection queue size: " + this._fileEntries.size()));
        if (this._fileEntries.size() > 0) {
            this._log.debug((Object)"Draining collection queue");
            while (this._fileEntries.size() > 0) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {}
            }
        }
        this._keepRunning = false;
        this._log.debug((Object)"Closing open files");
        this._log.debug((Object)("Files open: " + this._openFiles.size()));
        Collection<OpenFile> entries = this._openFiles.values();
        for (OpenFile entry : entries) {
            try {
                BufferedWriter writer = entry._bufferedWriter;
                this.addFooter(entry._bufferedWriter, entry._classifier);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this._log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this._log.debug((Object)"Open files closed");
    }

    private void addFooter(BufferedWriter bufferedWriter, Classifier classifier) throws IOException {
        switch (classifier) {
            case AVERAGE: {
                if (this._averageFooter == null) break;
                bufferedWriter.write(this._averageFooter);
                break;
            }
            case EXECUTION: {
                if (this._executionFooter == null) break;
                bufferedWriter.write(this._executionFooter);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled classifier: " + (Object)((Object)classifier));
            }
        }
    }

    private void addHeader(BufferedWriter bufferedWriter, Classifier classifier, Object ... headerParams) throws IOException {
        switch (classifier) {
            case AVERAGE: {
                if (this._averageHeader == null) break;
                bufferedWriter.write(String.format(this._averageHeader, headerParams));
                break;
            }
            case EXECUTION: {
                if (this._executionHeader == null) break;
                if (headerParams == null || headerParams.length == 0) {
                    bufferedWriter.write(this._executionHeader);
                    break;
                }
                bufferedWriter.write(String.format(this._executionHeader, headerParams));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled classifier: " + (Object)((Object)classifier));
            }
        }
    }

    private class FileEntryProcessor
    extends Thread {
        private FileEntryProcessor() {
        }

        public void run() {
            while (AbstractFileCollector.this._keepRunning) {
                try {
                    FileEntry fileEntry = (FileEntry)AbstractFileCollector.this._fileEntries.poll(AbstractFileCollector.this._timeOut, TimeUnit.MILLISECONDS);
                    if (fileEntry == null) continue;
                    BufferedWriter bw = AbstractFileCollector.this.getWriter(fileEntry._fileKey, fileEntry._classifier, fileEntry._taskName);
                    bw.write(fileEntry._formattedText);
                    bw.flush();
                }
                catch (Exception e) {
                    AbstractFileCollector.this._log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SUCCESS,
        FAILURE,
        NOT_RUN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Classifier {
        AVERAGE,
        EXECUTION;

    }

    public class FileEntry {
        String _taskName;
        String _formattedText;
        String _fileKey;
        Classifier _classifier;

        public FileEntry(String taskName, String formattedText, String fileKey, Classifier classifier) {
            this._taskName = taskName;
            this._formattedText = formattedText;
            this._fileKey = fileKey;
            this._classifier = classifier;
        }
    }

    private class OpenFile {
        private final BufferedWriter _bufferedWriter;
        private final Classifier _classifier;

        public OpenFile(BufferedWriter bufferedWriter, Classifier classifier) {
            this._bufferedWriter = bufferedWriter;
            this._classifier = classifier;
        }
    }
}

