/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.basher.Average;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.Collector;
import net.sourceforge.basher.Phase;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.CollectionStartedEvent;
import net.sourceforge.basher.events.CollectionStoppedEvent;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.events.ThreadAddedEvent;
import net.sourceforge.basher.events.ThreadRemovedEvent;
import net.sourceforge.basher.events.TickEvent;
import net.sourceforge.basher.internal.TimeSource;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollector
implements Collector,
BasherEventListener {
    private long _successes;
    private long _failures;
    private long _notRun;
    private long _min = 0L;
    private long _max;
    private long _total;
    private long _timeElapsed = System.currentTimeMillis();
    private List<Average> _averages = new ArrayList<Average>();
    private boolean _collecting;
    protected TimeSource _timeSource;
    protected Log _log;
    private int _runningThreads;

    @Override
    public void startCollecting() {
        this._collecting = true;
    }

    @Override
    public void stopCollecting() {
        this._collecting = false;
    }

    protected abstract void initializeCollector(BasherContext var1) throws Exception;

    @Override
    public void success(Task task, long elapsedTime) {
        ++this._successes;
        this.updateStats(elapsedTime);
    }

    @Override
    public void notRun(Task task, long elapsedTime) {
        ++this._notRun;
    }

    @Override
    public void fail(Task task, long elapsedTime, Throwable throwable) {
        ++this._failures;
        this.updateStats(elapsedTime);
    }

    private void updateStats(long elapsedTime) {
        this._total += elapsedTime;
        if (elapsedTime < this._min) {
            this._min = elapsedTime;
        }
        if (elapsedTime > this._max) {
            this._max = elapsedTime;
        }
    }

    @Override
    public long getFailures() {
        return this._failures;
    }

    @Override
    public long getSuccesses() {
        return this._successes;
    }

    @Override
    public long getNotRun() {
        return this._notRun;
    }

    @Override
    public long getTotal() {
        return this._failures + this._successes;
    }

    @Override
    public List<Average> getAverages() {
        return Collections.unmodifiableList(this._averages);
    }

    @Override
    public Average markAverage() {
        Average average = new Average(this._min, this._max, this._total, System.currentTimeMillis() - this._timeElapsed, this._successes, this._failures, this._notRun, this._runningThreads);
        if (this.isCollecting()) {
            this._averages.add(average);
        }
        this._min = Long.MAX_VALUE;
        this._max = 0L;
        this._total = 0L;
        this._successes = 0L;
        this._failures = 0L;
        this._notRun = 0L;
        this._timeElapsed = System.currentTimeMillis();
        return average;
    }

    public void setTimeSource(TimeSource timeSource) {
        this._timeSource = timeSource;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    @Override
    public boolean isCollecting() {
        return this._collecting;
    }

    @Override
    public void basherEvent(BasherEvent basherEvent) {
        if (basherEvent instanceof PhaseTransitionEvent) {
            PhaseTransitionEvent phaseTransitionEvent = (PhaseTransitionEvent)basherEvent;
            Phase newPhase = phaseTransitionEvent.getNewPhase();
            switch (newPhase) {
                case RUN: {
                    try {
                        BasherContext basherContext = phaseTransitionEvent.getBasherContext();
                        this.initializeCollector(basherContext);
                        this._runningThreads = basherContext.getInitialNumberThreads();
                    }
                    catch (Exception e) {
                        this._log.error((Object)("Unable to initialize collector for run: " + e.getMessage()), (Throwable)e);
                    }
                    break;
                }
                case COOLDOWN: 
                case END: {
                    this.stopCollecting();
                    break;
                }
            }
        } else if (basherEvent instanceof CollectionStartedEvent) {
            this.startCollecting();
        } else if (basherEvent instanceof CollectionStoppedEvent) {
            this.stopCollecting();
        } else if (basherEvent instanceof ThreadAddedEvent) {
            ++this._runningThreads;
        } else if (basherEvent instanceof ThreadRemovedEvent) {
            --this._runningThreads;
        } else if (basherEvent instanceof TickEvent) {
            Average average = this.markAverage();
        }
    }
}

