/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.events.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.EventManager;
import org.apache.commons.logging.Log;

public class SynchronousEventManager
implements EventManager {
    private Log _log;
    private List<BasherEventListener> _basherEventListeners = new ArrayList<BasherEventListener>();

    public void setLog(Log log) {
        this._log = log;
    }

    public void publish(BasherEvent basherEvent) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Received publish call for event: " + basherEvent));
        }
        ArrayList<BasherEventListener> basherEventListeners = new ArrayList<BasherEventListener>(this._basherEventListeners);
        for (BasherEventListener basherEventListener : basherEventListeners) {
            basherEventListener.basherEvent(basherEvent);
        }
    }

    public void addBasherEventListener(BasherEventListener basherEventListener) {
        if (this._basherEventListeners.contains(basherEventListener)) {
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Adding basher event listener: " + basherEventListener));
        }
        this._basherEventListeners.add(basherEventListener);
    }

    public void removeBasherEventListener(BasherEventListener basherEventListener) {
        if (!this._basherEventListeners.contains(basherEventListener)) {
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.info((Object)("Removing basher event listener: " + basherEventListener));
        }
        this._basherEventListeners.remove(basherEventListener);
    }
}

