/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.TaskManager;
import org.ops4j.gaderian.Registry;
import org.ops4j.gaderian.impl.RegistryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Basher {
    private static Registry _registry;
    private Thread _hook;
    private boolean _keepRunning = true;
    private static AtomicBoolean _shutdownInitiated;

    public static void main(String[] args) {
        Basher basher = new Basher();
        basher.createShutdownHook();
        basher.startShutdownTimer(args);
        basher.setSystemParameters(args);
        basher.startIt();
        basher.startBeanshell(args);
        basher.loop();
    }

    private void setSystemParameters(String[] args) {
        if (args.length != 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!arg.startsWith("-D")) continue;
                String[] properties = arg.substring(2).split("=");
                if (properties.length != 2) {
                    System.out.format("Invalid system property: %s", arg.substring(2));
                    System.out.println("Format should be '-Dproperty=value");
                    this.usage();
                }
                System.setProperty(properties[0], properties[1]);
            }
        }
    }

    private void startShutdownTimer(String[] args) {
        if (args.length != 0) {
            int index = this.findIndexOf(args, "-runfor");
            if (index == -1) {
                return;
            }
            long runFor = 0L;
            try {
                runFor = Long.parseLong(args[index + 1]);
            }
            catch (NumberFormatException e) {
                System.out.format("invalid value for seconds: %s", args[index + 1]);
                this.usage();
            }
            final long runForReal = runFor;
            System.out.format("Scheduling timed shutdown after %d seconds", runForReal);
            if (this._hook != null) {
                System.out.println("Removing registered shutdown hook");
                Runtime.getRuntime().removeShutdownHook(this._hook);
            }
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                public void run() {
                    Basher.this.shutdown("Shutting down after " + runForReal + " seconds of running");
                }
            }, runFor * 1000L);
        }
    }

    private void startIt() {
        if (_registry == null) {
            Basher.setRegistry(RegistryBuilder.constructDefaultRegistry());
        }
        Scheduler scheduler = (Scheduler)_registry.getService(Scheduler.class);
        scheduler.start();
    }

    private void loop() {
        while (this._keepRunning) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void createShutdownHook() {
        this._hook = new Thread(new Runnable(){

            public void run() {
                Basher.this.shutdown("Shutting down due to user interrupt");
            }
        });
        Runtime.getRuntime().addShutdownHook(this._hook);
    }

    private void shutdown(String shutdownMessage) {
        if (_shutdownInitiated.getAndSet(true)) {
            System.out.println("Shutdown already initiated, ignoring call");
            return;
        }
        System.out.println(shutdownMessage);
        if (_registry != null) {
            Scheduler scheduler = (Scheduler)_registry.getService(Scheduler.class);
            if (scheduler != null && scheduler.isRunning()) {
                scheduler.stop();
            }
            System.out.println("Cooling down ...");
            boolean allDone = false;
            while (!allDone) {
                Thread[] threadList = new Thread[Thread.activeCount()];
                int numThreads = Thread.currentThread().getThreadGroup().enumerate(threadList);
                allDone = true;
                for (int j = 0; j < numThreads; ++j) {
                    Thread thread = threadList[j];
                    if (thread == null || !thread.getName().startsWith("Basher")) continue;
                    allDone = false;
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {}
            }
            System.out.println("Task Invocation Statistics (total/successes/failures)");
            TaskManager taskManager = (TaskManager)_registry.getService(TaskManager.class);
            if (taskManager != null) {
                if (taskManager.getTasks().size() == 0) {
                    System.out.println("No tasks invoked");
                }
                System.out.println("Active Tasks");
                for (Task task : taskManager.getTasks()) {
                    System.out.format("%s (%d/%d/%d)", task.getName(), task.getInvocations(), task.getSuccesses(), task.getFailures());
                }
                System.out.println("Removed Tasks");
                for (Task task : taskManager.getRemovedTasks()) {
                    System.out.format("%s (%d/%d/%d)", task.getName(), task.getInvocations(), task.getSuccesses(), task.getFailures());
                }
            }
            System.out.println("Shutting down registry ...");
            _registry.shutdown();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this._keepRunning = false;
    }

    private void startBeanshell(String[] args) {
        if (args.length != 0) {
            int portIndex = this.findIndexOf(args, "-p");
            if (portIndex == -1) {
                return;
            }
            int port = 1234;
            try {
                port = Integer.parseInt(args[portIndex + 1]);
            }
            catch (NumberFormatException e) {
                System.out.format("invalid port: %s", args[portIndex + 1]);
                this.usage();
            }
            if (port < 1024) {
                System.out.println("port number must be greater than 1024");
                this.usage();
            }
            Interpreter interpreter = new Interpreter();
            try {
                interpreter.set("registry", (Object)_registry);
                interpreter.set("taskManager", _registry.getService(TaskManager.class));
                interpreter.set("scheduler", _registry.getService(Scheduler.class));
            }
            catch (EvalError evalError) {
                evalError.printStackTrace();
            }
            try {
                interpreter.set("portnum", port);
                interpreter.eval("setAccessibility(true)");
                interpreter.eval("server(portnum)");
                System.out.format("beanshell server started on port %d", port);
            }
            catch (Throwable throwable) {
                System.out.println("error starting the beanshell server");
            }
        }
    }

    private int findIndexOf(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals(name)) continue;
            if (i + 1 == args.length) {
                this.usage();
            }
            return i;
        }
        return -1;
    }

    private void usage() {
        System.out.println("usage: basher [-p port] [-runfor minutes] [-Dproperty=value]");
        System.exit(1);
    }

    public static void setRegistry(Registry registry) {
        if (_registry != null) {
            throw new IllegalStateException("Basher has already been initialized");
        }
        _registry = registry;
    }

    public static Registry getRegistry() {
        if (_registry == null) {
            throw new IllegalStateException("Basher has not been initialized");
        }
        if (_shutdownInitiated.get()) {
            throw new IllegalStateException("Basher shutdown has been initiated");
        }
        return _registry;
    }

    public static void fireCleanUpThread() {
        if (_shutdownInitiated.get()) {
            return;
        }
        try {
            if (_registry != null) {
                _registry.cleanupThread();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static <T> T getService(Class<T> service) throws Exception {
        if (_registry == null) {
            _registry = RegistryBuilder.constructDefaultRegistry();
        }
        return (T)_registry.getService(service);
    }

    static {
        _shutdownInitiated = new AtomicBoolean(false);
    }
}

