/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher;

import java.util.Date;

public class Average {
    private long _minTime;
    private long _maxTime;
    private long _totalTime;
    private long _totalEntries;
    private long _totalSuccessful;
    private long _totalFailed;
    private long _totalNotRun;
    private long _timeElapsed;
    private int _numThreads;
    private Date _timeStamp;

    public Average(long minTime, long maxTime, long totalTime, long timeElapsed, long totalSuccessful, long totalFailed, long totalNotRun, int numThreads) {
        this._minTime = minTime;
        this._maxTime = maxTime;
        this._totalTime = totalTime;
        this._totalSuccessful = totalSuccessful;
        this._totalFailed = totalFailed;
        this._totalNotRun = totalNotRun;
        this._totalEntries = totalFailed + totalSuccessful;
        this._timeElapsed = timeElapsed;
        this._numThreads = numThreads;
        this._timeStamp = new Date();
    }

    public long getTimeElapsed() {
        return this._timeElapsed;
    }

    public long getAverage() {
        if (this._totalEntries == 0L) {
            return 0L;
        }
        return this._totalTime / this._totalEntries;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    public long getTotalTime() {
        return this._totalTime;
    }

    public long getTotalEntries() {
        return this._totalEntries;
    }

    public Date getTimeStamp() {
        return new Date(this._timeStamp.getTime());
    }

    public float getTPS() {
        float seconds = this._timeElapsed / 1000L;
        if (seconds == 0.0f) {
            return 0.0f;
        }
        return (float)this._totalEntries / seconds;
    }

    public int getNumThreads() {
        return this._numThreads;
    }

    public long getTotalSuccessful() {
        return this._totalSuccessful;
    }

    public long getTotalFailed() {
        return this._totalFailed;
    }

    public long getTotalNotRun() {
        return this._totalNotRun;
    }

    public String formatOutput() {
        return String.format("elapsed time: %d min time: %s max time: %s total time: %s invocations: %d (%dS/%dF) not run: %d average time: %d tps: %f num threads: %d", this._timeElapsed, this._minTime == Long.MAX_VALUE ? "N/A" : Long.valueOf(this._minTime), this._maxTime, this._totalTime, this._totalEntries, this._totalSuccessful, this._totalFailed, this._totalNotRun, this.getAverage(), Float.valueOf(this.getTPS()), this.getNumThreads());
    }

    public String toString() {
        return "elapsed time: " + this._timeElapsed + " min time: " + (this._minTime == Long.MAX_VALUE ? "N/A" : "" + this._minTime) + " max time: " + this._maxTime + " total time: " + this._totalTime + " invocations: " + this._totalEntries + " average time: " + this.getAverage() + " tps: " + this.getTPS() + " num threads: " + this.getNumThreads();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Average average = (Average)o;
        if (this._maxTime != average._maxTime) {
            return false;
        }
        if (this._minTime != average._minTime) {
            return false;
        }
        if (this._numThreads != average._numThreads) {
            return false;
        }
        if (this._timeElapsed != average._timeElapsed) {
            return false;
        }
        if (this._totalEntries != average._totalEntries) {
            return false;
        }
        if (this._totalFailed != average._totalFailed) {
            return false;
        }
        if (this._totalNotRun != average._totalNotRun) {
            return false;
        }
        if (this._totalSuccessful != average._totalSuccessful) {
            return false;
        }
        if (this._totalTime != average._totalTime) {
            return false;
        }
        return !(this._timeStamp != null ? !this._timeStamp.equals(average._timeStamp) : average._timeStamp != null);
    }
}

