/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.util;

public class ToStringBuilder {
    private StringBuffer _buffer = new StringBuffer();
    private int _mode;
    private int _attributeCount;
    private static int _defaultMode;
    public static final int INCLUDE_PACKAGE_PREFIX = 1;
    public static final int INCLUDE_HASHCODE = 2;

    public ToStringBuilder(Object target) {
        this(target, _defaultMode);
    }

    public ToStringBuilder(Object target, int mode) {
        this._mode = mode;
        this.appendClassName(target);
        this.appendHashCode(target);
    }

    private void appendHashCode(Object target) {
        if ((this._mode & 2) == 0) {
            return;
        }
        this._buffer.append('@');
        this._buffer.append(Integer.toHexString(target.hashCode()));
    }

    private void appendClassName(Object target) {
        String className = target.getClass().getName();
        if ((this._mode & 1) != 0) {
            this._buffer.append(className);
            return;
        }
        int lastdotx = className.lastIndexOf(46);
        this._buffer.append(className.substring(lastdotx + 1));
    }

    public static int getDefaultMode() {
        return _defaultMode;
    }

    public static void setDefaultMode(int i) {
        _defaultMode = i;
    }

    public String toString() {
        if (this._attributeCount > 0) {
            this._buffer.append(']');
        }
        String result = this._buffer.toString();
        this._buffer = null;
        return result;
    }

    public void append(String attributeName, boolean value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, byte value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, short value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, int value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, Object value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, String value) {
        if (this._attributeCount++ == 0) {
            this._buffer.append('[');
        } else {
            this._buffer.append(' ');
        }
        this._buffer.append(attributeName);
        this._buffer.append('=');
        this._buffer.append(value);
    }
}

