/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.util;

import java.net.MalformedURLException;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.ops4j.gaderian.util.LocalizedNameGenerator;
import org.ops4j.gaderian.util.LocalizedResource;

public class LocalizedContextResourceFinder {
    private ServletContext _context;

    public LocalizedContextResourceFinder(ServletContext context) {
        this._context = context;
    }

    public LocalizedResource resolve(String contextPath, Locale locale) {
        String suffix;
        String basePath;
        int dotx = contextPath.lastIndexOf(46);
        if (dotx >= 0) {
            basePath = contextPath.substring(0, dotx);
            suffix = contextPath.substring(dotx);
        } else {
            basePath = contextPath;
            suffix = "";
        }
        LocalizedNameGenerator generator = new LocalizedNameGenerator(basePath, locale, suffix);
        while (generator.more()) {
            String candidatePath = generator.next();
            if (!this.isExistingResource(candidatePath)) continue;
            return new LocalizedResource(candidatePath, generator.getCurrentLocale());
        }
        return null;
    }

    private boolean isExistingResource(String path) {
        try {
            return this._context.getResource(path) != null;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }
}

