/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.ErrorLog;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.schema.Translator;
import org.ops4j.gaderian.service.ObjectProvider;
import org.ops4j.gaderian.service.impl.ServiceMessages;

public class ObjectTranslator
implements Translator {
    private ErrorLog _errorLog;
    private Map _providers = new HashMap();

    public Object translate(Module contributingModule, Class propertyType, String inputValue, Location location) {
        if (Gaderian.isBlank(inputValue)) {
            return null;
        }
        int colonx = inputValue.indexOf(58);
        if (colonx == -1) {
            return contributingModule.getTranslator("smart").translate(contributingModule, propertyType, inputValue, location);
        }
        if (colonx < 1) {
            this._errorLog.error(ServiceMessages.invalidProviderSelector(inputValue), null, null);
            return null;
        }
        String prefix = inputValue.substring(0, colonx);
        ObjectProvider provider = (ObjectProvider)this._providers.get(prefix);
        if (provider == null) {
            this._errorLog.error(ServiceMessages.unknownProviderPrefix(prefix), location, null);
            return null;
        }
        String locator = inputValue.substring(colonx + 1);
        try {
            return provider.provideObject(contributingModule, propertyType, locator, location);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), location, ex);
        }
    }

    public void setContributions(Map map) {
        this._providers = map;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

