/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ops4j.gaderian.service.ClassFabUtils;
import org.ops4j.gaderian.service.ClassFactory;
import org.ops4j.gaderian.service.InterfaceFab;
import org.ops4j.gaderian.service.InterfaceSynthesizer;
import org.ops4j.gaderian.service.MethodSignature;

public class InterfaceSynthesizerImpl
implements InterfaceSynthesizer {
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$java$lang$Object;

    public Class synthesizeInterface(Class beanClass) {
        Operation op = new Operation();
        this.explodeClass(beanClass, op);
        return this.createInterface(beanClass, op);
    }

    void explodeClass(Class beanClass, Operation op) {
        for (Class current = beanClass; current != (class$java$lang$Object == null ? InterfaceSynthesizerImpl.class$("java.lang.Object") : class$java$lang$Object); current = current.getSuperclass()) {
            op.processClass(current);
        }
        op.processInterfaceQueue();
    }

    Class createInterface(Class beanClass, Operation op) {
        String name = ClassFabUtils.generateClassName(beanClass);
        return this.createInterface(name, op);
    }

    private Class createInterface(String name, Operation op) {
        InterfaceFab fab = this._classFactory.newInterface(name);
        Iterator i = op.getInterfaces().iterator();
        while (i.hasNext()) {
            Class interfaceClass = (Class)i.next();
            fab.addInterface(interfaceClass);
        }
        i = op.getNonInterfaceMethodSignatures().iterator();
        while (i.hasNext()) {
            MethodSignature sig = (MethodSignature)i.next();
            fab.addMethod(sig);
        }
        return fab.createInterface();
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Operation {
        private Set _interfaces = new HashSet();
        private Set _interfaceMethods = new HashSet();
        private Set _allMethods = new HashSet();
        private List _interfaceQueue = new ArrayList();

        private Operation() {
        }

        public Set getInterfaces() {
            return this._interfaces;
        }

        public Set getNonInterfaceMethodSignatures() {
            HashSet result = new HashSet(this._allMethods);
            result.removeAll(this._interfaceMethods);
            return result;
        }

        public void processInterfaceQueue() {
            while (!this._interfaceQueue.isEmpty()) {
                Class interfaceClass = (Class)this._interfaceQueue.remove(0);
                this.processInterface(interfaceClass);
            }
        }

        private void processInterface(Class interfaceClass) {
            Class<?>[] interfaces = interfaceClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterfaceToQueue(interfaces[i]);
            }
            Method[] methods = interfaceClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodSignature sig = new MethodSignature(methods[i]);
                this._interfaceMethods.add(sig);
            }
        }

        private void addInterfaceToQueue(Class interfaceClass) {
            if (this._interfaces.contains(interfaceClass)) {
                return;
            }
            this._interfaces.add(interfaceClass);
            this._interfaceQueue.add(interfaceClass);
        }

        public void processClass(Class beanClass) {
            Class<?>[] interfaces = beanClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterfaceToQueue(interfaces[i]);
            }
            Method[] methods = beanClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                int modifiers = m.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                MethodSignature sig = new MethodSignature(m);
                this._allMethods.add(sig);
            }
        }
    }
}

