/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.ops4j.gaderian.ErrorLog;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.impl.BaseLocatable;
import org.ops4j.gaderian.service.EventLinker;
import org.ops4j.gaderian.service.impl.ServiceMessages;

public class EventLinkerImpl
extends BaseLocatable
implements EventLinker {
    private ErrorLog _errorLog;
    private Map _producerEventSets;

    public EventLinkerImpl(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void addEventListener(Object producer, String eventSetName, Object consumer, Location location) {
        EventSetDescriptor[] sets = this.getEventSets(producer);
        boolean nameMatch = Gaderian.isNonBlank(eventSetName);
        Class<?> consumerClass = consumer.getClass();
        int count = 0;
        for (int i = 0; i < sets.length; ++i) {
            EventSetDescriptor set = sets[i];
            String name = set.getName();
            if (nameMatch) {
                if (!eventSetName.equals(name)) continue;
                if (this.isAssignable(set, consumerClass)) {
                    this.addEventListener(producer, set, consumer, location);
                } else {
                    this._errorLog.error(ServiceMessages.notCompatibleWithEvent(consumer, set, producer), location, null);
                }
                return;
            }
            if (!this.isAssignable(set, consumerClass)) continue;
            this.addEventListener(producer, set, consumer, location);
            ++count;
        }
        if (count == 0) {
            if (nameMatch) {
                this._errorLog.error(ServiceMessages.noSuchEventSet(producer, eventSetName), location, null);
            } else {
                this._errorLog.error(ServiceMessages.noEventMatches(consumer, producer), location, null);
            }
        }
    }

    private boolean isAssignable(EventSetDescriptor set, Class consumerClass) {
        return set.getListenerType().isAssignableFrom(consumerClass);
    }

    private void addEventListener(Object producer, EventSetDescriptor set, Object consumer, Location location) {
        Method m = set.getAddListenerMethod();
        try {
            m.invoke(producer, consumer);
        }
        catch (Exception ex) {
            this._errorLog.error(ServiceMessages.unableToAddListener(producer, set, consumer, location, ex), location, ex);
        }
    }

    private EventSetDescriptor[] getEventSets(Object producer) {
        return this.getEventSets(producer.getClass());
    }

    private synchronized EventSetDescriptor[] getEventSets(Class producerClass) {
        EventSetDescriptor[] result = null;
        if (this._producerEventSets == null) {
            this._producerEventSets = new HashMap();
        } else {
            result = (EventSetDescriptor[])this._producerEventSets.get(producerClass);
        }
        if (result == null) {
            result = this.findEventSets(producerClass);
            this._producerEventSets.put(producerClass, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventSetDescriptor[] findEventSets(Class producerClass) {
        Object object = Gaderian.INTROSPECTOR_MUTEX;
        synchronized (object) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(producerClass);
                return beanInfo.getEventSetDescriptors();
            }
            catch (IntrospectionException ex) {
                this._errorLog.error(ServiceMessages.unableToIntrospectClass(producerClass, ex), null, ex);
                return new EventSetDescriptor[0];
            }
        }
    }
}

