/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import javassist.CtClass;
import javassist.NotFoundException;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.service.ClassFabUtils;
import org.ops4j.gaderian.service.impl.GaderianClassPool;
import org.ops4j.gaderian.service.impl.ServiceMessages;

public class CtClassSource {
    private GaderianClassPool _pool;
    private int _createdClassCount = 0;

    public int getCreatedClassCount() {
        return this._createdClassCount;
    }

    public CtClassSource(GaderianClassPool pool) {
        this._pool = pool;
    }

    public boolean canConvert(Class searchClass) {
        this.ensureClassLoaderAvailable(searchClass);
        String name = ClassFabUtils.getJavaClassName(searchClass);
        try {
            this._pool.get(name);
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    public CtClass getCtClass(Class searchClass) {
        this.ensureClassLoaderAvailable(searchClass);
        String name = ClassFabUtils.getJavaClassName(searchClass);
        try {
            return this._pool.get(name);
        }
        catch (NotFoundException ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToLookupClass(name, ex), ex);
        }
    }

    private void ensureClassLoaderAvailable(Class searchClass) {
        ClassLoader loader = searchClass.getClassLoader();
        this._pool.appendClassLoader(loader);
    }

    public CtClass newClass(String name, Class superClass) {
        CtClass ctSuperClass = this.getCtClass(superClass);
        return this._pool.makeClass(name, ctSuperClass);
    }

    public CtClass newInterface(String name) {
        return this._pool.makeInterface(name);
    }

    public Class createClass(CtClass ctClass) {
        try {
            Class result = this._pool.toClass(ctClass);
            ++this._createdClassCount;
            return result;
        }
        catch (Throwable ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToWriteClass(ctClass, ex), ex);
        }
    }
}

