/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.ServiceImplementationFactoryParameters;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.service.impl.BuilderFacet;
import org.ops4j.gaderian.service.impl.BuilderParameter;
import org.ops4j.gaderian.service.impl.ServiceMessages;
import org.ops4j.gaderian.util.ConstructorUtils;

public class BuilderFactoryLogic {
    private ServiceImplementationFactoryParameters _factoryParameters;
    private String _serviceId;
    private BuilderParameter _parameter;
    private Module _contributingModule;

    public BuilderFactoryLogic(ServiceImplementationFactoryParameters factoryParameters, BuilderParameter parameter) {
        this._factoryParameters = factoryParameters;
        this._parameter = parameter;
        this._serviceId = factoryParameters.getServiceId();
        this._contributingModule = factoryParameters.getInvokingModule();
    }

    public Object createService() {
        try {
            Object result = this.instantiateCoreServiceInstance();
            this._parameter.assemble(result, this._factoryParameters);
            return result;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceMessages.failureBuildingService(this._serviceId, ex), this._parameter.getLocation(), ex);
        }
    }

    private Object instantiateCoreServiceInstance() {
        Class serviceClass = this._contributingModule.resolveType(this._parameter.getClassName());
        if (serviceClass.isInterface() || (serviceClass.getModifiers() & 0x400) != 0) {
            throw new ApplicationRuntimeException(ServiceMessages.absractClass(serviceClass.getName()), this._parameter.getLocation(), null);
        }
        List parameters = this._parameter.getParameters();
        if (this._parameter.getAutowireServices() && parameters.isEmpty()) {
            return this.instantiateConstructorAutowiredInstance(serviceClass);
        }
        return this.instantiateExplicitConstructorInstance(serviceClass, parameters);
    }

    private Object instantiateExplicitConstructorInstance(Class serviceClass, List builderParameters) {
        int numberOfParams = builderParameters.size();
        List constructorCandidates = ConstructorUtils.getConstructorsOfLength(serviceClass, numberOfParams);
        Iterator candidates = constructorCandidates.iterator();
        block0: while (candidates.hasNext()) {
            Constructor candidate = (Constructor)candidates.next();
            Class<?>[] parameterTypes = candidate.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < numberOfParams; ++i) {
                BuilderFacet facet = (BuilderFacet)builderParameters.get(i);
                if (!facet.isAssignableToType(this._factoryParameters, parameterTypes[i])) continue block0;
                parameters[i] = facet.getFacetValue(this._factoryParameters, parameterTypes[i]);
            }
            return ConstructorUtils.invoke(candidate, parameters);
        }
        throw new ApplicationRuntimeException(ServiceMessages.unableToFindAutowireConstructor(), this._parameter.getLocation(), null);
    }

    private Object instantiateConstructorAutowiredInstance(Class serviceClass) {
        List serviceConstructorCandidates = this.getOrderedServiceConstructors(serviceClass);
        Iterator candidates = serviceConstructorCandidates.iterator();
        block0: while (candidates.hasNext()) {
            Constructor candidate = (Constructor)candidates.next();
            Class<?>[] parameterTypes = candidate.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameters.length; ++i) {
                BuilderFacet facet = this._parameter.getFacetForType(this._factoryParameters, parameterTypes[i]);
                if (facet != null && facet.canAutowireConstructorParameter()) {
                    parameters[i] = facet.getFacetValue(this._factoryParameters, parameterTypes[i]);
                    continue;
                }
                if (!this._contributingModule.containsService(parameterTypes[i])) continue block0;
                parameters[i] = this._contributingModule.getService(parameterTypes[i]);
            }
            return ConstructorUtils.invoke(candidate, parameters);
        }
        throw new ApplicationRuntimeException(ServiceMessages.unableToFindAutowireConstructor(), this._parameter.getLocation(), null);
    }

    private List getOrderedServiceConstructors(Class serviceClass) {
        ArrayList orderedInterfaceConstructors = new ArrayList();
        Constructor<?>[] constructors = serviceClass.getDeclaredConstructors();
        block0: for (int i = 0; i < constructors.length; ++i) {
            if (!Modifier.isPublic(constructors[i].getModifiers())) continue;
            Class<?>[] parameterTypes = constructors[i].getParameterTypes();
            if (parameterTypes.length > 0) {
                HashSet seenTypes = new HashSet();
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (!parameterTypes[j].isInterface() || seenTypes.contains(parameterTypes[j])) continue block0;
                    seenTypes.add(parameterTypes[j]);
                }
            }
            orderedInterfaceConstructors.add(constructors[i]);
        }
        Collections.sort(orderedInterfaceConstructors, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Constructor)o2).getParameterTypes().length - ((Constructor)o1).getParameterTypes().length;
            }
        });
        return orderedInterfaceConstructors;
    }
}

