/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import org.apache.commons.logging.Log;
import org.ops4j.gaderian.AssemblyParameters;
import org.ops4j.gaderian.impl.BaseLocatable;
import org.ops4j.gaderian.util.PropertyUtils;

public abstract class BuilderFacet
extends BaseLocatable {
    private String _propertyName;

    public abstract Object getFacetValue(AssemblyParameters var1, Class var2);

    public abstract boolean isAssignableToType(AssemblyParameters var1, Class var2);

    public String getPropertyName() {
        return this._propertyName;
    }

    public void setPropertyName(String string) {
        this._propertyName = string;
    }

    public String wireProperty(Object service, AssemblyParameters assemblyParameters) {
        try {
            String autowirePropertyName = this.autowire(service, assemblyParameters);
            if (autowirePropertyName != null) {
                return autowirePropertyName;
            }
            if (this._propertyName == null) {
                return null;
            }
            Class targetType = PropertyUtils.getPropertyType(service, this._propertyName);
            Object value = this.getFacetValue(assemblyParameters, targetType);
            PropertyUtils.write(service, this._propertyName, value);
            Log log = assemblyParameters.getLog();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set property " + this._propertyName + " to " + value));
            }
            return this._propertyName;
        }
        catch (Exception ex) {
            assemblyParameters.getErrorLog().error(ex.getMessage(), this.getLocation(), ex);
            return null;
        }
    }

    private String autowire(Object target, AssemblyParameters assemblyParameters) {
        if (this._propertyName != null) {
            return null;
        }
        String defaultPropertyName = this.getDefaultPropertyName();
        if (defaultPropertyName == null) {
            return null;
        }
        if (!PropertyUtils.isWritable(target, defaultPropertyName)) {
            return null;
        }
        Class propertyType = PropertyUtils.getPropertyType(target, defaultPropertyName);
        if (this.isAssignableToType(assemblyParameters, propertyType)) {
            Object facetValue = this.getFacetValue(assemblyParameters, propertyType);
            PropertyUtils.write(target, defaultPropertyName, facetValue);
            Log log = assemblyParameters.getLog();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Autowired property " + defaultPropertyName + " to " + facetValue));
            }
            return defaultPropertyName;
        }
        return null;
    }

    protected String getDefaultPropertyName() {
        return null;
    }

    public boolean canAutowireConstructorParameter() {
        return false;
    }
}

