/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.ops4j.gaderian.AssemblyInstruction;
import org.ops4j.gaderian.AssemblyParameters;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.impl.BaseLocatable;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.service.impl.BuilderFacet;
import org.ops4j.gaderian.service.impl.EventLinkerImpl;
import org.ops4j.gaderian.service.impl.EventRegistration;
import org.ops4j.gaderian.service.impl.ServiceMessages;
import org.ops4j.gaderian.util.PropertyUtils;

public class AssemblyInstructionImpl
extends BaseLocatable
implements AssemblyInstruction {
    private List _properties = new ArrayList();
    private List _events = new ArrayList();
    private String _initializeMethod;
    private boolean _autowireServices;

    public void addProperty(BuilderFacet facet) {
        this._properties.add(facet);
    }

    public List getProperties() {
        return this._properties;
    }

    public void addEventRegistration(EventRegistration registration) {
        this._events.add(registration);
    }

    public List getEventRegistrations() {
        return this._events;
    }

    public String getInitializeMethod() {
        return this._initializeMethod;
    }

    public void setInitializeMethod(String string) {
        this._initializeMethod = string;
    }

    public boolean getAutowireServices() {
        return this._autowireServices;
    }

    public void setAutowireServices(boolean autowireServices) {
        this._autowireServices = autowireServices;
    }

    public void assemble(Object service, AssemblyParameters assemblyParameters) {
        this.setProperties(service, assemblyParameters);
        this.registerForEvents(service, assemblyParameters);
        this.invokeInitializer(service, assemblyParameters);
    }

    private void setProperties(Object service, AssemblyParameters factoryParameters) {
        HashSet writeableProperties = new HashSet(PropertyUtils.getWriteableProperties(service));
        Iterator i = this._properties.iterator();
        while (i.hasNext()) {
            BuilderFacet facet = (BuilderFacet)i.next();
            String propertyName = facet.wireProperty(service, factoryParameters);
            if (propertyName == null) continue;
            writeableProperties.remove(propertyName);
        }
        if (this._autowireServices) {
            i = writeableProperties.iterator();
            while (i.hasNext()) {
                String propertyName = (String)i.next();
                this.autowireService(service, propertyName, factoryParameters);
            }
        }
    }

    private void autowireService(Object service, String propertyName, AssemblyParameters factoryParameters) {
        Class propertyType = PropertyUtils.getPropertyType(service, propertyName);
        Module invokingModule = factoryParameters.getInvokingModule();
        Log log = factoryParameters.getLog();
        try {
            if (invokingModule.containsService(propertyType)) {
                Object collaboratingService = invokingModule.getService(propertyType);
                PropertyUtils.write(service, propertyName, collaboratingService);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Autowired service property " + propertyName + " to " + collaboratingService));
                }
            }
        }
        catch (Exception ex) {
            invokingModule.getErrorHandler().error(log, ServiceMessages.autowirePropertyFailure(propertyName, factoryParameters.getServiceId(), ex), this.getLocation(), ex);
        }
    }

    private void registerForEvents(Object result, AssemblyParameters factoryParameters) {
        List eventRegistrations = this.getEventRegistrations();
        if (eventRegistrations.isEmpty()) {
            return;
        }
        EventLinkerImpl linker = new EventLinkerImpl(factoryParameters.getErrorLog());
        Iterator i = eventRegistrations.iterator();
        while (i.hasNext()) {
            EventRegistration er = (EventRegistration)i.next();
            linker.addEventListener(er.getProducer(), er.getEventSetName(), result, er.getLocation());
        }
    }

    private void invokeInitializer(Object service, AssemblyParameters factoryParameters) {
        String methodName = this.getInitializeMethod();
        boolean allowMissing = Gaderian.isBlank(methodName);
        String searchMethodName = allowMissing ? "initializeService" : methodName;
        try {
            this.findAndInvokeInitializerMethod(service, searchMethodName, allowMissing);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            factoryParameters.getErrorLog().error(ServiceMessages.unableToInitializeService(factoryParameters.getServiceId(), searchMethodName, service.getClass(), cause), this.getLocation(), cause);
        }
        catch (Exception ex) {
            factoryParameters.getErrorLog().error(ServiceMessages.unableToInitializeService(factoryParameters.getServiceId(), searchMethodName, service.getClass(), ex), this.getLocation(), ex);
        }
    }

    private void findAndInvokeInitializerMethod(Object service, String methodName, boolean allowMissing) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> serviceClass = service.getClass();
        try {
            Method m = serviceClass.getMethod(methodName, null);
            m.invoke(service, null);
        }
        catch (NoSuchMethodException ex) {
            if (allowMissing) {
                return;
            }
            throw ex;
        }
    }
}

