/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.schema.rules;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Element;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.schema.SchemaProcessor;
import org.ops4j.gaderian.schema.Translator;
import org.ops4j.gaderian.schema.rules.BaseRule;
import org.ops4j.gaderian.schema.rules.RuleUtils;
import org.ops4j.gaderian.schema.rules.RulesMessages;
import org.ops4j.gaderian.util.PropertyUtils;

public class ReadAttributeRule
extends BaseRule {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$ops4j$gaderian$schema$rules$ReadAttributeRule == null ? (class$org$ops4j$gaderian$schema$rules$ReadAttributeRule = ReadAttributeRule.class$("org.ops4j.gaderian.schema.rules.ReadAttributeRule")) : class$org$ops4j$gaderian$schema$rules$ReadAttributeRule));
    private String _attributeName;
    private String _propertyName;
    private boolean _skipIfNull = true;
    private String _translator;
    static /* synthetic */ Class class$org$ops4j$gaderian$schema$rules$ReadAttributeRule;

    public ReadAttributeRule() {
    }

    public ReadAttributeRule(String attributeName, String propertyName, String translator, Location location) {
        this.setLocation(location);
        this._attributeName = attributeName;
        this._propertyName = propertyName;
        this._translator = translator;
    }

    public void begin(SchemaProcessor processor, Element element) {
        String value = this.getAttributeValue(processor, element);
        if (value == null && this._skipIfNull) {
            return;
        }
        value = RuleUtils.processText(processor, element, value);
        Object target = processor.peek();
        try {
            Translator t = this._translator == null ? processor.getAttributeTranslator(this._attributeName) : processor.getTranslator(this._translator);
            Class propertyType = PropertyUtils.getPropertyType(target, this._propertyName);
            Object finalValue = t.translate(processor.getContributingModule(), propertyType, value, element.getLocation());
            PropertyUtils.write(target, this._propertyName, finalValue);
        }
        catch (Exception ex) {
            ErrorHandler eh = processor.getContributingModule().getErrorHandler();
            eh.error(LOG, RulesMessages.readAttributeFailure(this._attributeName, element, processor, ex), element.getLocation(), ex);
        }
    }

    private String getAttributeValue(SchemaProcessor processor, Element element) {
        String rawValue = element.getAttributeValue(this._attributeName);
        return rawValue == null ? processor.getAttributeDefault(this._attributeName) : rawValue;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public boolean getSkipIfNull() {
        return this._skipIfNull;
    }

    public String getTranslator() {
        return this._translator;
    }

    public void setAttributeName(String string) {
        this._attributeName = string;
    }

    public void setPropertyName(String string) {
        this._propertyName = string;
    }

    public void setSkipIfNull(boolean b) {
        this._skipIfNull = b;
    }

    public void setTranslator(String string) {
        this._translator = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

