/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.schema.rules;

import java.util.Map;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.schema.Translator;
import org.ops4j.gaderian.schema.rules.RuleUtils;
import org.ops4j.gaderian.schema.rules.RulesMessages;

public class IntTranslator
implements Translator {
    private int _minValue;
    private boolean _isMinValue;
    private int _maxValue;
    private boolean _isMaxValue;
    private int _defaultValue = 0;

    public IntTranslator() {
    }

    public IntTranslator(String initializer) {
        String maxInit;
        String minInit;
        Map m = RuleUtils.convertInitializer(initializer);
        String defaultInit = (String)m.get("default");
        if (defaultInit != null) {
            this._defaultValue = Integer.parseInt(defaultInit);
        }
        if ((minInit = (String)m.get("min")) != null) {
            this._isMinValue = true;
            this._minValue = Integer.parseInt(minInit);
        }
        if ((maxInit = (String)m.get("max")) != null) {
            this._isMaxValue = true;
            this._maxValue = Integer.parseInt(maxInit);
        }
    }

    public Object translate(Module contributingModule, Class propertyType, String inputValue, Location location) {
        int value;
        if (Gaderian.isBlank(inputValue)) {
            return new Integer(this._defaultValue);
        }
        try {
            value = Integer.parseInt(inputValue);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(RulesMessages.invalidIntValue(inputValue), location, null);
        }
        if (this._isMinValue && value < this._minValue) {
            throw new ApplicationRuntimeException(RulesMessages.minIntValue(inputValue, this._minValue));
        }
        if (this._isMaxValue && value > this._maxValue) {
            throw new ApplicationRuntimeException(RulesMessages.maxIntValue(inputValue, this._maxValue));
        }
        return new Integer(value);
    }
}

