/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.schema.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.internal.Visibility;
import org.ops4j.gaderian.parse.BaseAnnotationHolder;
import org.ops4j.gaderian.schema.AttributeModel;
import org.ops4j.gaderian.schema.ElementModel;
import org.ops4j.gaderian.schema.Schema;

public class SchemaImpl
extends BaseAnnotationHolder
implements Schema {
    private List _elementModels;
    private List _shareableElementModels;
    private Visibility _visibility = Visibility.PUBLIC;
    private Module _module;
    private String _id;

    public String getModuleId() {
        return this._module.getModuleId();
    }

    public String getId() {
        return this._id;
    }

    public Visibility getVisibility() {
        return this._visibility;
    }

    public boolean visibleToModule(String moduleId) {
        if (this._visibility == Visibility.PUBLIC) {
            return true;
        }
        return this.getModuleId().equals(moduleId);
    }

    public void addElementModel(ElementModel model) {
        if (this._elementModels == null) {
            this._elementModels = new ArrayList();
        }
        this._elementModels.add(model);
        this._shareableElementModels = null;
    }

    public List getElementModel() {
        if (this._shareableElementModels == null) {
            this._shareableElementModels = this._elementModels == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._elementModels);
        }
        return this._shareableElementModels;
    }

    public boolean canInstancesBeKeyed() {
        boolean emptyModel;
        boolean bl = emptyModel = this._elementModels == null || this._elementModels.isEmpty();
        if (emptyModel) {
            return false;
        }
        Iterator i = this._elementModels.iterator();
        while (i.hasNext()) {
            ElementModel model = (ElementModel)i.next();
            if (model.getKeyAttribute() != null) continue;
            return false;
        }
        return true;
    }

    public void validateKeyAttributes() {
        if (this._elementModels == null) {
            return;
        }
        Iterator i = this._elementModels.iterator();
        while (i.hasNext()) {
            AttributeModel keyAm;
            ElementModel em = (ElementModel)i.next();
            String key = em.getKeyAttribute();
            if (key == null || (keyAm = em.getAttributeModel(key)) != null) continue;
            throw new ApplicationRuntimeException("Key attribute '" + key + "' of element '" + em.getElementName() + "' never declared.", em.getLocation(), null);
        }
    }

    public void setVisibility(Visibility visibility) {
        this._visibility = visibility;
    }

    public void setModule(Module module) {
        this._module = module;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Module getDefiningModule() {
        return this._module;
    }
}

