/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.parse;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.ClassResolver;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.Resource;
import org.ops4j.gaderian.parse.DescriptorParser;
import org.ops4j.gaderian.parse.ModuleDescriptor;
import org.ops4j.gaderian.parse.ParseMessages;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlResourceProcessor {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$ops4j$gaderian$parse$XmlResourceProcessor == null ? (class$org$ops4j$gaderian$parse$XmlResourceProcessor = XmlResourceProcessor.class$("org.ops4j.gaderian.parse.XmlResourceProcessor")) : class$org$ops4j$gaderian$parse$XmlResourceProcessor));
    protected ClassResolver _resolver;
    protected ErrorHandler _errorHandler;
    private DescriptorParser _contentHandler;
    private SAXParser _saxParser;
    static /* synthetic */ Class class$org$ops4j$gaderian$parse$XmlResourceProcessor;

    public XmlResourceProcessor(ClassResolver resolver, ErrorHandler errorHandler) {
        this._resolver = resolver;
        this._errorHandler = errorHandler;
    }

    public ModuleDescriptor processResource(Resource resource) {
        if (this._contentHandler == null) {
            this._contentHandler = new DescriptorParser(this._errorHandler);
        }
        this._contentHandler.initialize(resource, this._resolver);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parsing " + resource));
            }
            ModuleDescriptor descriptor = this.parseResource(resource, this.getSAXParser(), this._contentHandler);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Result: " + descriptor));
            }
            ModuleDescriptor moduleDescriptor = descriptor;
            return moduleDescriptor;
        }
        catch (ApplicationRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this._saxParser = null;
            throw new ApplicationRuntimeException(ParseMessages.errorReadingDescriptor(resource, e), resource, this._contentHandler.getLocation(), e);
        }
        finally {
            this._contentHandler.resetParser();
        }
    }

    protected ModuleDescriptor parseResource(Resource resource, SAXParser parser, DescriptorParser contentHandler) throws SAXException, IOException {
        InputSource source = this.getInputSource(resource);
        parser.parse(source, (DefaultHandler)contentHandler);
        return contentHandler.getModuleDescriptor();
    }

    private InputSource getInputSource(Resource resource) {
        try {
            URL url = resource.getResourceURL();
            return new InputSource(url.openStream());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(ParseMessages.missingResource(resource), resource, null, e);
        }
    }

    private SAXParser getSAXParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        if (this._saxParser == null) {
            this._saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        return this._saxParser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

