/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.order;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.ErrorLog;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.impl.ErrorLogImpl;
import org.ops4j.gaderian.order.ObjectOrdering;
import org.ops4j.gaderian.order.OrdererMessages;
import org.ops4j.gaderian.util.Defense;
import org.ops4j.gaderian.util.StringUtils;

public class Orderer {
    private final ErrorLog _errorLog;
    private final String _objectType;
    private List _orderingsList = null;
    private Map _orderingsMap = null;
    private Map _nodeMap = null;
    private Node _leader;
    private Node _trailer;
    static /* synthetic */ Class class$org$ops4j$gaderian$order$Orderer;

    public Orderer(ErrorHandler errorHandler, String objectType) {
        this(LogFactory.getLog((Class)(class$org$ops4j$gaderian$order$Orderer == null ? (class$org$ops4j$gaderian$order$Orderer = Orderer.class$("org.ops4j.gaderian.order.Orderer")) : class$org$ops4j$gaderian$order$Orderer)), errorHandler, objectType);
    }

    public Orderer(Log log, ErrorHandler errorHandler, String objectType) {
        this(new ErrorLogImpl(errorHandler, log), objectType);
    }

    public Orderer(ErrorLog errorLog, String objectType) {
        Defense.notNull(errorLog, "errorLog");
        Defense.notNull(objectType, "objectType");
        this._errorLog = errorLog;
        this._objectType = objectType;
    }

    public void add(Object object, String name, String prereqs, String postreqs) {
        ObjectOrdering o;
        if (this._orderingsMap == null) {
            this._orderingsMap = new HashMap();
            this._orderingsList = new ArrayList();
        }
        if ((o = this.getOrderable(name)) != null) {
            this._errorLog.error(OrdererMessages.duplicateName(this._objectType, name, object, o.getObject()), Gaderian.getLocation(object), null);
            return;
        }
        o = new ObjectOrdering(object, name, prereqs, postreqs);
        this._orderingsMap.put(name, o);
        this._orderingsList.add(o);
    }

    private ObjectOrdering getOrderable(String name) {
        return (ObjectOrdering)this._orderingsMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOrderedObjects() {
        if (this._orderingsMap == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            this._nodeMap = new HashMap();
            this.initializeGraph();
            List list = this._trailer.getOrder();
            return list;
        }
        finally {
            this._nodeMap = null;
            this._leader = null;
            this._trailer = null;
        }
    }

    private void initializeGraph() {
        this.addNodes();
        if (this._leader == null) {
            this._leader = new Node(null, "*-leader-*");
        }
        if (this._trailer == null) {
            this._trailer = new Node(null, "*-trailer-*");
        }
        this.addDependencies();
    }

    private Node getNode(String name) {
        return (Node)this._nodeMap.get(this.getOrderable(name));
    }

    private void addNodes() {
        Iterator i = this._orderingsList.iterator();
        while (i.hasNext()) {
            ObjectOrdering o = (ObjectOrdering)i.next();
            Node node = new Node(o.getObject(), o.getName());
            this._nodeMap.put(o, node);
            if ("*".equals(o.getPostreqs())) {
                if (this._leader == null) {
                    this._leader = node;
                } else {
                    this._errorLog.error(OrdererMessages.dupeLeader(this._objectType, o, this.getOrderable(this._leader.getName())), Gaderian.getLocation(o.getObject()), null);
                }
            }
            if (!"*".equals(o.getPrereqs())) continue;
            if (this._trailer == null) {
                this._trailer = node;
                continue;
            }
            this._errorLog.error(OrdererMessages.dupeTrailer(this._objectType, o, this.getOrderable(this._trailer.getName())), Gaderian.getLocation(o.getObject()), null);
        }
    }

    private void addDependencies() {
        Iterator i = this._orderingsList.iterator();
        while (i.hasNext()) {
            ObjectOrdering o = (ObjectOrdering)i.next();
            this.addDependencies(o, this.getNode(o.getName()));
        }
    }

    private void addDependencies(ObjectOrdering orderable, Node node) {
        this.addPreRequisites(orderable, node);
        this.addPostRequisites(orderable, node);
        try {
            if (node != this._leader) {
                node.addDependency(this._leader);
            }
            if (node != this._trailer) {
                this._trailer.addDependency(node);
            }
        }
        catch (ApplicationRuntimeException ex) {
            String name = node.getName();
            ObjectOrdering trigger = this.getOrderable(name);
            this._errorLog.error(OrdererMessages.dependencyCycle(this._objectType, orderable, ex), Gaderian.getLocation(trigger.getObject()), ex);
        }
    }

    private void addPreRequisites(ObjectOrdering ordering, Node node) {
        String prereqs = ordering.getPrereqs();
        if ("*".equals(prereqs)) {
            return;
        }
        String[] names = StringUtils.split(prereqs);
        for (int i = 0; i < names.length; ++i) {
            String prename = names[i];
            Node prenode = this.getNode(prename);
            if (prenode == null) {
                this._errorLog.error(OrdererMessages.badDependency(this._objectType, prename, ordering), Gaderian.getLocation(ordering.getObject()), null);
                continue;
            }
            try {
                node.addDependency(prenode);
                continue;
            }
            catch (ApplicationRuntimeException ex) {
                this._errorLog.error(OrdererMessages.dependencyCycle(this._objectType, ordering, ex), Gaderian.getLocation(ordering.getObject()), ex);
            }
        }
    }

    private void addPostRequisites(ObjectOrdering ordering, Node node) {
        String postreqs = ordering.getPostreqs();
        if ("*".equals(postreqs)) {
            return;
        }
        String[] names = StringUtils.split(postreqs);
        for (int i = 0; i < names.length; ++i) {
            String postname = names[i];
            Node postnode = this.getNode(postname);
            if (postnode == null) {
                this._errorLog.error(OrdererMessages.badDependency(this._objectType, postname, ordering), Gaderian.getLocation(ordering.getObject()), null);
                continue;
            }
            try {
                postnode.addDependency(node);
                continue;
            }
            catch (ApplicationRuntimeException ex) {
                this._errorLog.error(OrdererMessages.dependencyCycle(this._objectType, ordering, ex), Gaderian.getLocation(ordering.getObject()), ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Node {
        private Object _object;
        private String _name;
        private List _dependencies;

        public Node(Object o, String name) {
            this._object = o;
            this._name = name;
            this._dependencies = new ArrayList();
        }

        public String getName() {
            return this._name;
        }

        public void addDependency(Node n) {
            if (n.isReachable(this)) {
                throw new ApplicationRuntimeException("A cycle has been detected from the initial object [" + this._name + "]", Gaderian.getLocation(this._object), null);
            }
            this._dependencies.add(n);
        }

        private boolean isReachable(Node n) {
            boolean reachable = n == this;
            Iterator i = this._dependencies.iterator();
            while (i.hasNext() && !reachable) {
                Node dep = (Node)i.next();
                reachable = dep == n ? true : dep.isReachable(n);
            }
            return reachable;
        }

        public List getOrder() {
            ArrayList result = new ArrayList();
            this.fillOrder(result);
            return result;
        }

        private void fillOrder(List result) {
            if (result.contains(this._object)) {
                return;
            }
            Iterator i = this._dependencies.iterator();
            while (i.hasNext()) {
                Node dep = (Node)i.next();
                dep.fillOrder(result);
            }
            if (this._object != null) {
                result.add(this._object);
            }
        }
    }
}

