/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl.servicemodel;

import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Discardable;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import org.ops4j.gaderian.impl.ConstructableServicePoint;
import org.ops4j.gaderian.impl.ProxyUtils;
import org.ops4j.gaderian.impl.servicemodel.AbstractServiceModelImpl;
import org.ops4j.gaderian.impl.servicemodel.ServiceModelMessages;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.service.ThreadCleanupListener;
import org.ops4j.gaderian.service.ThreadEventNotifier;

public final class ThreadedServiceModel
extends AbstractServiceModelImpl {
    protected static final String SERVICE_ACCESSOR_METHOD_NAME = "_service";
    private final Object _serviceProxy;
    private final ThreadEventNotifier _notifier;
    private final ThreadLocal _activeService = new ThreadLocal();
    private Class _serviceInterface;
    static /* synthetic */ Class class$org$ops4j$gaderian$service$ThreadEventNotifier;

    public ThreadedServiceModel(ConstructableServicePoint servicePoint) {
        super(servicePoint);
        this._serviceInterface = servicePoint.getServiceInterface();
        Module module = this.getServicePoint().getModule();
        this._notifier = (ThreadEventNotifier)module.getService("gaderian.ThreadEventNotifier", class$org$ops4j$gaderian$service$ThreadEventNotifier == null ? (class$org$ops4j$gaderian$service$ThreadEventNotifier = ThreadedServiceModel.class$("org.ops4j.gaderian.service.ThreadEventNotifier")) : class$org$ops4j$gaderian$service$ThreadEventNotifier);
        this._serviceProxy = this.createServiceProxy();
    }

    public Object getService() {
        return this._serviceProxy;
    }

    private Object createServiceProxy() {
        ConstructableServicePoint servicePoint = this.getServicePoint();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Creating ThreadedProxy for service " + servicePoint.getExtensionPointId()));
        }
        Object proxy = ProxyUtils.createDelegatingProxy("ThreadedProxy", this, "getServiceImplementationForCurrentThread", servicePoint);
        Object intercepted = this.addInterceptors(proxy);
        RegistryShutdownListener outerProxy = ProxyUtils.createOuterProxy(intercepted, servicePoint);
        servicePoint.addRegistryShutdownListener(outerProxy);
        return outerProxy;
    }

    public Object getServiceImplementationForCurrentThread() {
        Object result = this._activeService.get();
        if (result == null) {
            result = this.constructInstanceForCurrentThread();
        }
        return result;
    }

    private Object constructInstanceForCurrentThread() {
        try {
            Object core = this.constructCoreServiceImplementation();
            if (core instanceof RegistryShutdownListener) {
                this._log.error((Object)ServiceModelMessages.registryCleanupIgnored(this.getServicePoint()));
            }
            this._notifier.addThreadCleanupListener(new CleanupListener(core));
            if (!this._serviceInterface.isInstance(core)) {
                core = this.constructBridgeProxy(core);
            }
            this._activeService.set(core);
            return core;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceModelMessages.unableToConstructService(this.getServicePoint(), ex), ex);
        }
    }

    private void unbindServiceFromCurrentThread() {
        this._activeService.set(null);
    }

    public void instantiateService() {
        this.getServiceImplementationForCurrentThread();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CleanupListener
    implements ThreadCleanupListener {
        private final Object _core;

        CleanupListener(Object core) {
            this._core = core;
        }

        public void threadDidCleanup() {
            ThreadedServiceModel.this.unbindServiceFromCurrentThread();
            if (this._core instanceof Discardable) {
                Discardable d = (Discardable)this._core;
                d.threadDidDiscardService();
            }
        }
    }
}

