/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl.servicemodel;

import java.util.ArrayList;
import java.util.List;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.PoolManageable;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import org.ops4j.gaderian.impl.ConstructableServicePoint;
import org.ops4j.gaderian.impl.ProxyUtils;
import org.ops4j.gaderian.impl.servicemodel.AbstractServiceModelImpl;
import org.ops4j.gaderian.impl.servicemodel.ServiceModelMessages;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.service.ThreadCleanupListener;
import org.ops4j.gaderian.service.ThreadEventNotifier;

public class PooledServiceModel
extends AbstractServiceModelImpl {
    protected static final String SERVICE_ACCESSOR_METHOD_NAME = "_service";
    private final Object _serviceProxy;
    private final ThreadEventNotifier _notifier;
    private final ThreadLocal _activeService = new ThreadLocal();
    private final List _servicePool = new ArrayList();
    private Class _serviceInterface;
    private static final PoolManageable NULL_MANAGEABLE = new PoolManageable(){

        public void activateService() {
        }

        public void passivateService() {
        }
    };
    static /* synthetic */ Class class$org$ops4j$gaderian$service$ThreadEventNotifier;

    public PooledServiceModel(ConstructableServicePoint servicePoint) {
        super(servicePoint);
        this._serviceInterface = servicePoint.getServiceInterface();
        Module module = this.getServicePoint().getModule();
        this._notifier = (ThreadEventNotifier)module.getService("gaderian.ThreadEventNotifier", class$org$ops4j$gaderian$service$ThreadEventNotifier == null ? (class$org$ops4j$gaderian$service$ThreadEventNotifier = PooledServiceModel.class$("org.ops4j.gaderian.service.ThreadEventNotifier")) : class$org$ops4j$gaderian$service$ThreadEventNotifier);
        this._serviceProxy = this.constructServiceProxy();
    }

    public Object getService() {
        return this._serviceProxy;
    }

    private Object constructServiceProxy() {
        ConstructableServicePoint servicePoint = this.getServicePoint();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Creating PooledProxy for service " + servicePoint.getExtensionPointId()));
        }
        Object proxy = ProxyUtils.createDelegatingProxy("PooledProxy", this, "getServiceImplementationForCurrentThread", servicePoint);
        Object intercepted = this.addInterceptors(proxy);
        RegistryShutdownListener outerProxy = ProxyUtils.createOuterProxy(intercepted, servicePoint);
        servicePoint.addRegistryShutdownListener(outerProxy);
        return outerProxy;
    }

    public Object getServiceImplementationForCurrentThread() {
        PooledService pooled = (PooledService)this._activeService.get();
        if (pooled == null) {
            pooled = this.obtainPooledService();
            pooled.activate();
            this._notifier.addThreadCleanupListener(pooled);
            this._activeService.set(pooled);
        }
        return pooled.getService();
    }

    private PooledService obtainPooledService() {
        PooledService result = this.getServiceFromPool();
        if (result == null) {
            result = this.constructPooledService();
        }
        return result;
    }

    private synchronized PooledService getServiceFromPool() {
        int count = this._servicePool.size();
        if (count == 0) {
            return null;
        }
        return (PooledService)this._servicePool.remove(count - 1);
    }

    private synchronized void returnServiceToPool(PooledService pooled) {
        this._servicePool.add(pooled);
    }

    private PooledService constructPooledService() {
        try {
            Object core = this.constructCoreServiceImplementation();
            if (!this._serviceInterface.isInstance(core)) {
                core = this.constructBridgeProxy(core);
            }
            this.registerWithShutdownCoordinator(core);
            return new PooledService(core);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceModelMessages.unableToConstructService(this.getServicePoint(), ex), ex);
        }
    }

    private void unbindPooledServiceFromCurrentThread(PooledService pooled) {
        this._activeService.set(null);
        pooled.passivate();
        this.returnServiceToPool(pooled);
    }

    public void instantiateService() {
        this.getServiceImplementationForCurrentThread();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PooledService
    implements ThreadCleanupListener {
        private Object _core;
        private PoolManageable _managed;

        PooledService(Object core) {
            this._core = core;
            this._managed = core instanceof PoolManageable ? (PoolManageable)core : NULL_MANAGEABLE;
        }

        public void threadDidCleanup() {
            PooledServiceModel.this.unbindPooledServiceFromCurrentThread(this);
        }

        void activate() {
            this._managed.activateService();
        }

        void passivate() {
            this._managed.passivateService();
        }

        public Object getService() {
            return this._core;
        }
    }
}

