/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl.servicemodel;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.ShutdownCoordinator;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import org.ops4j.gaderian.impl.ConstructableServicePoint;
import org.ops4j.gaderian.impl.InterceptorStackImpl;
import org.ops4j.gaderian.impl.ProxyBuilder;
import org.ops4j.gaderian.impl.servicemodel.ServiceModelMessages;
import org.ops4j.gaderian.internal.ServiceImplementationConstructor;
import org.ops4j.gaderian.internal.ServiceInterceptorContribution;
import org.ops4j.gaderian.internal.ServiceModel;
import org.ops4j.gaderian.service.ClassFab;
import org.ops4j.gaderian.util.ConstructorUtils;

public abstract class AbstractServiceModelImpl
implements ServiceModel {
    protected final Log _log;
    private ConstructableServicePoint _servicePoint;
    private Class _bridgeProxyClass;
    static /* synthetic */ Class class$org$ops4j$gaderian$ShutdownCoordinator;

    public AbstractServiceModelImpl(ConstructableServicePoint servicePoint) {
        this._log = LogFactory.getLog((String)servicePoint.getExtensionPointId());
        this._servicePoint = servicePoint;
    }

    protected Object addInterceptors(Object core) {
        int count;
        List interceptors = this._servicePoint.getOrderedInterceptorContributions();
        int n = count = interceptors == null ? 0 : interceptors.size();
        if (count == 0) {
            return core;
        }
        InterceptorStackImpl stack = new InterceptorStackImpl(this._log, this._servicePoint, core);
        for (int i = count - 1; i >= 0; --i) {
            ServiceInterceptorContribution ic = (ServiceInterceptorContribution)interceptors.get(i);
            stack.process(ic);
        }
        return stack.peek();
    }

    protected Object constructCoreServiceImplementation() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Constructing core service implementation for service " + this._servicePoint.getExtensionPointId()));
        }
        Class serviceInterface = this._servicePoint.getServiceInterface();
        Class declaredInterface = this._servicePoint.getDeclaredInterface();
        ServiceImplementationConstructor constructor = this._servicePoint.getServiceConstructor();
        Object result = constructor.constructCoreServiceImplementation();
        if (result == null) {
            throw new ApplicationRuntimeException(ServiceModelMessages.factoryReturnedNull(this._servicePoint), constructor.getLocation(), null);
        }
        if (!serviceInterface.isInstance(result) && !declaredInterface.isInstance(result)) {
            throw new ApplicationRuntimeException(ServiceModelMessages.factoryWrongInterface(this._servicePoint, result, serviceInterface), constructor.getLocation(), null);
        }
        Gaderian.setLocation(result, constructor.getLocation());
        return result;
    }

    protected Object constructServiceImplementation() {
        Object result = this.constructNewServiceImplementation();
        this._servicePoint.clearConstructorInformation();
        return result;
    }

    protected Object constructNewServiceImplementation() {
        try {
            Object core = this.constructCoreServiceImplementation();
            Object intercepted = this.addInterceptors(core);
            return intercepted;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceModelMessages.unableToConstructService(this._servicePoint, ex), ex);
        }
    }

    public ConstructableServicePoint getServicePoint() {
        return this._servicePoint;
    }

    protected Object constructBridgeProxy(Object service) {
        Class bridgeProxyClass = this.getBridgeProxyClass(service);
        return ConstructorUtils.invokeConstructor(bridgeProxyClass, new Object[]{service});
    }

    private synchronized Class getBridgeProxyClass(Object service) {
        if (this._bridgeProxyClass == null) {
            this._bridgeProxyClass = this.constructBridgeProxyClass(service);
        }
        return this._bridgeProxyClass;
    }

    private Class constructBridgeProxyClass(Object service) {
        ProxyBuilder builder = new ProxyBuilder("BridgeProxy", this.getServicePoint());
        ClassFab cf = builder.getClassFab();
        Class<?> serviceType = service.getClass();
        cf.addField("_service", serviceType);
        cf.addConstructor(new Class[]{serviceType}, null, "{ super(); _service = $1; }");
        builder.addServiceMethods("_service");
        return cf.createClass();
    }

    protected void registerWithShutdownCoordinator(Object service) {
        if (service instanceof RegistryShutdownListener) {
            ShutdownCoordinator coordinator = (ShutdownCoordinator)this.getServicePoint().getModule().getService(class$org$ops4j$gaderian$ShutdownCoordinator == null ? (class$org$ops4j$gaderian$ShutdownCoordinator = AbstractServiceModelImpl.class$("org.ops4j.gaderian.ShutdownCoordinator")) : class$org$ops4j$gaderian$ShutdownCoordinator);
            RegistryShutdownListener asListener = (RegistryShutdownListener)service;
            coordinator.addRegistryShutdownListener(asListener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void instantiateService();

    public abstract /* synthetic */ Object getService();
}

